/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.deploy.cache.Cache;
import com.sun.deploy.cache.CacheEntry;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.util.Trace;
import com.sun.javaws.CacheUtil;
import com.sun.javaws.exceptions.JNLPException;
import com.sun.javaws.jnl.ExtensionDesc;
import com.sun.javaws.jnl.JARDesc;
import com.sun.javaws.jnl.JREDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.LaunchDescFactory;
import com.sun.javaws.jnl.PackageDesc;
import com.sun.javaws.jnl.PropertyDesc;
import com.sun.javaws.jnl.ResourceVisitor;
import com.sun.javaws.jnl.ResourcesDesc;
import com.sun.javaws.progress.CustomProgress;
import com.sun.javaws.ui.DownloadWindow;
import com.sun.jnlp.JNLPClassLoaderIf;
import com.sun.jnlp.JNLPClassLoaderUtil;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.jnlp.DownloadService;
import javax.jnlp.DownloadServiceListener;

public final class DownloadServiceImpl
implements DownloadService {
    private static DownloadServiceImpl _sharedInstance = null;
    private ProgressHelper _defaultProgressHelper = null;

    private DownloadServiceImpl() {
    }

    public static synchronized DownloadServiceImpl getInstance() {
        DownloadServiceImpl.initialize();
        return _sharedInstance;
    }

    public static synchronized void initialize() {
        if (_sharedInstance == null) {
            _sharedInstance = new DownloadServiceImpl();
        }
    }

    public void setDefaultProgressHelper(DownloadServiceListener downloadServiceListener) {
        this._defaultProgressHelper = this.getProgressHelper(downloadServiceListener);
    }

    public ProgressHelper getDefaultProgressHelper() {
        if (this._defaultProgressHelper == null) {
            this._defaultProgressHelper = (ProgressHelper)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    DownloadWindow downloadWindow = new DownloadWindow();
                    downloadWindow.initialize(JNLPClassLoaderUtil.getInstance().getLaunchDesc(), false, false);
                    return new DefaultProgressHelper(downloadWindow);
                }
            });
        }
        return this._defaultProgressHelper;
    }

    public DownloadServiceListener getDefaultProgressWindow() {
        return this.getDefaultProgressHelper();
    }

    public boolean isResourceCached(final URL uRL, final String string) {
        Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (DownloadServiceImpl.this.isResourceValid(uRL, string)) {
                    try {
                        if (DownloadEngine.isResourceCached((URL)uRL, null, (String)string)) {
                            return Boolean.TRUE;
                        }
                    }
                    catch (IOException iOException) {
                        Trace.ignoredException((Exception)iOException);
                    }
                }
                return Boolean.FALSE;
            }
        });
        return bl;
    }

    public boolean isPartCached(String string) {
        return this.isPartCached(new String[]{string});
    }

    public boolean isPartCached(final String[] stringArray) {
        Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                LaunchDesc launchDesc = JNLPClassLoaderUtil.getInstance().getLaunchDesc();
                ResourcesDesc resourcesDesc = launchDesc.getResources();
                if (resourcesDesc == null) {
                    return Boolean.FALSE;
                }
                JARDesc[] jARDescArray = resourcesDesc.getPartJars(stringArray);
                return new Boolean(DownloadServiceImpl.this.isJARInCache(jARDescArray, true));
            }
        });
        return bl;
    }

    public boolean isExtensionPartCached(URL uRL, String string, String string2) {
        return this.isExtensionPartCached(uRL, string, new String[]{string2});
    }

    public boolean isExtensionPartCached(final URL uRL, final String string, final String[] stringArray) {
        Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                LaunchDesc launchDesc = JNLPClassLoaderUtil.getInstance().getLaunchDesc();
                ResourcesDesc resourcesDesc = launchDesc.getResources();
                if (resourcesDesc == null) {
                    return Boolean.FALSE;
                }
                JARDesc[] jARDescArray = resourcesDesc.getExtensionPart(uRL, string, stringArray);
                return new Boolean(DownloadServiceImpl.this.isJARInCache(jARDescArray, true));
            }
        });
        return bl;
    }

    public void loadResource(final URL uRL, final String string, final DownloadServiceListener downloadServiceListener) throws IOException {
        if (this.isResourceValid(uRL, string)) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        ProgressHelper progressHelper = DownloadServiceImpl.this.getProgressHelper(downloadServiceListener);
                        try {
                            if (uRL.toString().endsWith(".jar")) {
                                JNLPClassLoaderIf jNLPClassLoaderIf = JNLPClassLoaderUtil.getInstance();
                                jNLPClassLoaderIf.addResource(uRL, string, null);
                                if (!DownloadServiceImpl.this.isResourceCached(uRL, string)) {
                                    progressHelper = DownloadServiceImpl.this.getProgressHelper(downloadServiceListener);
                                    jNLPClassLoaderIf.downloadResource(uRL, string, progressHelper, true);
                                }
                            } else {
                                DownloadEngine.getResource((URL)uRL, null, (String)string, null, (boolean)true);
                                CacheEntry cacheEntry = Cache.getCacheEntry((URL)uRL, null, (String)string);
                                if (cacheEntry != null && cacheEntry.isJNLPFile()) {
                                    DownloadServiceImpl.this.loadResourceRecursivly(cacheEntry, downloadServiceListener);
                                }
                            }
                        }
                        catch (JNLPException jNLPException) {
                            throw new IOException(jNLPException.getMessage());
                        }
                        finally {
                            progressHelper.done();
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (IOException)privilegedActionException.getException();
            }
        }
    }

    private void loadResourceRecursivly(CacheEntry cacheEntry, final DownloadServiceListener downloadServiceListener) {
        try {
            File file = new File(cacheEntry.getResourceFilename());
            URL uRL = new URL(cacheEntry.getURL());
            LaunchDesc launchDesc = LaunchDescFactory.buildDescriptor(file, null, null, uRL);
            ResourcesDesc resourcesDesc = launchDesc.getResources();
            if (resourcesDesc != null) {
                resourcesDesc.visit(new ResourceVisitor(){

                    public void visitJARDesc(JARDesc jARDesc) {
                        try {
                            DownloadServiceImpl.this.loadResource(jARDesc.getLocation(), jARDesc.getVersion(), downloadServiceListener);
                        }
                        catch (IOException iOException) {
                            Trace.ignored((Throwable)iOException);
                        }
                    }

                    public void visitExtensionDesc(ExtensionDesc extensionDesc) {
                        try {
                            DownloadServiceImpl.this.loadResource(extensionDesc.getLocation(), extensionDesc.getVersion(), downloadServiceListener);
                        }
                        catch (IOException iOException) {
                            Trace.ignored((Throwable)iOException);
                        }
                    }

                    public void visitPropertyDesc(PropertyDesc propertyDesc) {
                    }

                    public void visitPackageDesc(PackageDesc packageDesc) {
                    }

                    public void visitJREDesc(JREDesc jREDesc) {
                    }
                });
            }
        }
        catch (Exception exception) {
            Trace.ignored((Throwable)exception);
        }
    }

    public void loadPart(String string, DownloadServiceListener downloadServiceListener) throws IOException {
        this.loadPart(new String[]{string}, downloadServiceListener);
    }

    public void loadPart(final String[] stringArray, final DownloadServiceListener downloadServiceListener) throws IOException {
        if (this.isPartCached(stringArray)) {
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    ProgressHelper progressHelper = DownloadServiceImpl.this.getProgressHelper(downloadServiceListener);
                    try {
                        JNLPClassLoaderUtil.getInstance().downloadParts(stringArray, progressHelper, true);
                    }
                    catch (JNLPException jNLPException) {
                        throw new IOException(jNLPException.getMessage());
                    }
                    finally {
                        progressHelper.done();
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    public void loadExtensionPart(URL uRL, String string, String string2, DownloadServiceListener downloadServiceListener) throws IOException {
        this.loadExtensionPart(uRL, string, new String[]{string2}, downloadServiceListener);
    }

    public void loadExtensionPart(final URL uRL, final String string, final String[] stringArray, final DownloadServiceListener downloadServiceListener) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    ProgressHelper progressHelper = DownloadServiceImpl.this.getProgressHelper(downloadServiceListener);
                    try {
                        JNLPClassLoaderUtil.getInstance().downloadExtensionParts(uRL, string, stringArray, progressHelper, true);
                    }
                    catch (JNLPException jNLPException) {
                        throw new IOException(jNLPException.getMessage());
                    }
                    finally {
                        progressHelper.done();
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    public void removeResource(final URL uRL, final String string) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    if (DownloadServiceImpl.this.isResourceValid(uRL, string)) {
                        if (uRL.toString().endsWith("jnlp")) {
                            CacheUtil.remove(Cache.getCacheEntry((URL)uRL, null, (String)string));
                        }
                        DownloadEngine.removeCachedResource((URL)uRL, null, (String)string);
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    public void removePart(String string) throws IOException {
        this.removePart(new String[]{string});
    }

    public void removePart(final String[] stringArray) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    LaunchDesc launchDesc = JNLPClassLoaderUtil.getInstance().getLaunchDesc();
                    ResourcesDesc resourcesDesc = launchDesc.getResources();
                    if (resourcesDesc == null) {
                        return null;
                    }
                    JARDesc[] jARDescArray = resourcesDesc.getPartJars(stringArray);
                    DownloadServiceImpl.this.removeJARFromCache(jARDescArray);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    public void removeExtensionPart(URL uRL, String string, String string2) throws IOException {
        this.removeExtensionPart(uRL, string, new String[]{string2});
    }

    public void removeExtensionPart(final URL uRL, final String string, final String[] stringArray) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    LaunchDesc launchDesc = JNLPClassLoaderUtil.getInstance().getLaunchDesc();
                    ResourcesDesc resourcesDesc = launchDesc.getResources();
                    if (resourcesDesc == null) {
                        return null;
                    }
                    JARDesc[] jARDescArray = resourcesDesc.getExtensionPart(uRL, string, stringArray);
                    DownloadServiceImpl.this.removeJARFromCache(jARDescArray);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    private void removeJARFromCache(JARDesc[] jARDescArray) throws IOException {
        if (jARDescArray == null) {
            return;
        }
        if (jARDescArray.length == 0) {
            return;
        }
        for (int i = 0; i < jARDescArray.length; ++i) {
            DownloadEngine.removeCachedResource((URL)jARDescArray[i].getLocation(), null, (String)jARDescArray[i].getVersion());
        }
    }

    private boolean isJARInCache(JARDesc[] jARDescArray, boolean bl) {
        if (jARDescArray == null) {
            return false;
        }
        if (jARDescArray.length == 0) {
            return false;
        }
        boolean bl2 = true;
        for (int i = 0; i < jARDescArray.length; ++i) {
            if (jARDescArray[i].isNativeLib()) {
                try {
                    if (DownloadEngine.getCachedJarFile((URL)jARDescArray[i].getLocation(), (String)jARDescArray[i].getVersion()) != null) {
                        if (bl) continue;
                        return true;
                    }
                    bl2 = false;
                }
                catch (IOException iOException) {
                    Trace.ignoredException((Exception)iOException);
                    bl2 = false;
                }
                continue;
            }
            try {
                if (DownloadEngine.getCachedJarFile((URL)jARDescArray[i].getLocation(), (String)jARDescArray[i].getVersion()) != null) {
                    if (bl) continue;
                    return true;
                }
                bl2 = false;
                continue;
            }
            catch (IOException iOException) {
                Trace.ignoredException((Exception)iOException);
                bl2 = false;
            }
        }
        return bl2;
    }

    private boolean isResourceValid(URL uRL, String string) {
        LaunchDesc launchDesc = JNLPClassLoaderUtil.getInstance().getLaunchDesc();
        JARDesc[] jARDescArray = launchDesc.getResources().getEagerOrAllJarDescs(true);
        if (launchDesc.getSecurityModel() != 0) {
            return true;
        }
        for (int i = 0; i < jARDescArray.length; ++i) {
            if (!uRL.toString().equals(jARDescArray[i].getLocation().toString()) || string != null && !string.equals(jARDescArray[i].getVersion())) continue;
            return true;
        }
        URL uRL2 = launchDesc.getCodebase();
        return uRL2 != null && uRL != null && uRL.toString().startsWith(uRL2.toString());
    }

    private ProgressHelper getProgressHelper(DownloadServiceListener downloadServiceListener) {
        if (downloadServiceListener instanceof ProgressHelper) {
            return (ProgressHelper)downloadServiceListener;
        }
        return new ProgressHelper(downloadServiceListener);
    }

    private class DefaultProgressHelper
    extends ProgressHelper {
        private DownloadWindow _dw = null;

        DefaultProgressHelper(final DownloadWindow downloadWindow) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    DefaultProgressHelper.this._dw = downloadWindow;
                    DefaultProgressHelper.this._dw.showLoadingProgressScreen();
                    return null;
                }
            });
        }

        public void initialize() {
            this._dw.resetCancled();
        }

        public void progress(URL uRL, String string, long l, long l2, int n) {
            this.ensureVisible();
            this._dw.progress(uRL, string, l, l2, n);
            if (this._dw.isCanceled()) {
                throw new RuntimeException("canceled by user");
            }
        }

        public void validating(URL uRL, String string, long l, long l2, int n) {
            this.ensureVisible();
            this._dw.validating(uRL, string, l, l2, n);
        }

        public void upgradingArchive(URL uRL, String string, int n, int n2) {
            this.ensureVisible();
            this._dw.upgradingArchive(uRL, string, n, n2);
        }

        public void downloadFailed(URL uRL, String string) {
            this.hideFrame();
        }

        private void ensureVisible() {
            if (!this._dw.isVisible()) {
                this._dw.setVisible(true);
            }
        }

        private synchronized void hideFrame() {
            this._dw.resetCancled();
            this._dw.setVisible(false);
        }

        public void done() {
            this.hideFrame();
        }

        public void extensionDownload(String string, int n) {
            this._dw.extensionDownload(string, n);
        }

        public void jreDownload(String string, URL uRL) {
            this._dw.jreDownload(string, uRL);
        }

        public void setHeading(String string, boolean bl) {
            this._dw.setHeading(string, bl);
        }

        public void setStatus(String string) {
            this._dw.setStatus(string);
        }

        public Component getOwner() {
            return this._dw.getOwner();
        }

        public void setVisible(boolean bl) {
            this._dw.setVisible(bl);
        }

        public void setProgressBarVisible(boolean bl) {
            this._dw.setProgressBarVisible(bl);
        }

        public void setProgressBarValue(int n) {
            this._dw.setProgressBarValue(n);
        }

        public void showLaunchingApplication(String string) {
            this._dw.showLaunchingApplication(string);
        }
    }

    private class ProgressHelper
    extends CustomProgress {
        private DownloadServiceListener _dsp = null;

        public ProgressHelper() {
            this._dsp = null;
        }

        public ProgressHelper(DownloadServiceListener downloadServiceListener) {
            this.setAppThreadGroup(Thread.currentThread().getThreadGroup());
            this.setListener(downloadServiceListener);
            this._dsp = downloadServiceListener;
            if (this._dsp instanceof DefaultProgressHelper) {
                ((DefaultProgressHelper)this._dsp).initialize();
            }
            this._dsp.progress(null, null, 0L, 0L, -1);
        }

        public void done() {
            if (this._dsp instanceof DefaultProgressHelper) {
                ((DefaultProgressHelper)this._dsp).done();
            }
        }
    }
}

