/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Handler;
import java.util.logging.LogRecord;

public abstract class Formatter {
    protected Formatter() {
    }

    public abstract String format(LogRecord var1);

    public String getHead(Handler handler) {
        return "";
    }

    public String getTail(Handler handler) {
        return "";
    }

    public synchronized String formatMessage(LogRecord logRecord) {
        String string = logRecord.getMessage();
        ResourceBundle resourceBundle = logRecord.getResourceBundle();
        if (resourceBundle != null) {
            try {
                string = resourceBundle.getString(logRecord.getMessage());
            }
            catch (MissingResourceException missingResourceException) {
                string = logRecord.getMessage();
            }
        }
        try {
            Object[] objectArray = logRecord.getParameters();
            if (objectArray == null || objectArray.length == 0) {
                return string;
            }
            if (string.indexOf("{0") >= 0 || string.indexOf("{1") >= 0 || string.indexOf("{2") >= 0 || string.indexOf("{3") >= 0) {
                return MessageFormat.format(string, objectArray);
            }
            return string;
        }
        catch (Exception exception) {
            return string;
        }
    }
}

