/*
 * Decompiled with CFR 0.152.
 */
package sun.swing.plaf.synth;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import sun.swing.CachedPainter;

public class Paint9Painter
extends CachedPainter {
    private static final Insets EMPTY_INSETS = new Insets(0, 0, 0, 0);
    public static final int PAINT_TOP_LEFT = 1;
    public static final int PAINT_TOP = 2;
    public static final int PAINT_TOP_RIGHT = 4;
    public static final int PAINT_LEFT = 8;
    public static final int PAINT_CENTER = 16;
    public static final int PAINT_RIGHT = 32;
    public static final int PAINT_BOTTOM_RIGHT = 64;
    public static final int PAINT_BOTTOM = 128;
    public static final int PAINT_BOTTOM_LEFT = 256;
    public static final int PAINT_ALL = 512;

    public static boolean validImage(Image image) {
        return image != null && image.getWidth(null) > 0 && image.getHeight(null) > 0;
    }

    public Paint9Painter(int n) {
        super(n);
    }

    public void paint(Component component, Graphics graphics, int n, int n2, int n3, int n4, Image image, Insets insets, Insets insets2, PaintType paintType, int n5) {
        if (image == null) {
            return;
        }
        super.paint(component, graphics, n, n2, n3, n4, new Object[]{image, insets, insets2, paintType, n5});
    }

    protected void paintToImage(Component component, Image image, Graphics graphics, int n, int n2, Object[] objectArray) {
        int n3 = 0;
        while (n3 < objectArray.length) {
            Image image2 = (Image)objectArray[n3++];
            Insets insets = (Insets)objectArray[n3++];
            Insets insets2 = (Insets)objectArray[n3++];
            PaintType paintType = (PaintType)((Object)objectArray[n3++]);
            int n4 = (Integer)objectArray[n3++];
            this.paint9(graphics, 0, 0, n, n2, image2, insets, insets2, paintType, n4);
        }
    }

    protected void paint9(Graphics graphics, int n, int n2, int n3, int n4, Image image, Insets insets, Insets insets2, PaintType paintType, int n5) {
        if (!Paint9Painter.validImage(image)) {
            return;
        }
        if (insets == null) {
            insets = EMPTY_INSETS;
        }
        if (insets2 == null) {
            insets2 = EMPTY_INSETS;
        }
        int n6 = image.getWidth(null);
        int n7 = image.getHeight(null);
        if (paintType == PaintType.CENTER) {
            graphics.drawImage(image, n + (n3 - n6) / 2, n2 + (n4 - n7) / 2, null);
        } else if (paintType == PaintType.TILE) {
            int n8 = 0;
            int n9 = n2 + n4;
            for (int i = n2; i < n9; i += n7 - n8) {
                int n10 = 0;
                int n11 = n + n3;
                for (int j = n; j < n11; j += n6 - n10) {
                    int n12 = Math.min(n11, j + n6 - n10);
                    int n13 = Math.min(n9, i + n7 - n8);
                    graphics.drawImage(image, j, i, n12, n13, n10, n8, n10 + n12 - j, n8 + n13 - i, null);
                    n10 = 0;
                }
                n8 = 0;
            }
        } else {
            boolean bl;
            int n14 = insets.top;
            int n15 = insets.left;
            int n16 = insets.bottom;
            int n17 = insets.right;
            int n18 = insets2.top;
            int n19 = insets2.left;
            int n20 = insets2.bottom;
            int n21 = insets2.right;
            if (n14 + n16 > n7) {
                n16 = n14 = Math.max(0, n7 / 2);
                n18 = n14;
                n20 = n14;
            }
            if (n15 + n17 > n6) {
                n15 = n17 = Math.max(0, n6 / 2);
                n21 = n17;
                n19 = n17;
            }
            if (n18 + n20 > n4) {
                n18 = n20 = Math.max(0, n4 / 2 - 1);
            }
            if (n19 + n21 > n3) {
                n19 = n21 = Math.max(0, n3 / 2 - 1);
            }
            boolean bl2 = bl = paintType == PaintType.PAINT9_STRETCH;
            if ((n5 & 0x200) != 0) {
                n5 = 0x1FF & ~n5;
            }
            if ((n5 & 8) != 0) {
                this.drawChunk(image, graphics, bl, n, n2 + n18, n + n19, n2 + n4 - n20, 0, n14, n15, n7 - n16, false);
            }
            if ((n5 & 1) != 0) {
                this.drawImage(image, graphics, n, n2, n + n19, n2 + n18, 0, 0, n15, n14);
            }
            if ((n5 & 2) != 0) {
                this.drawChunk(image, graphics, bl, n + n19, n2, n + n3 - n21, n2 + n18, n15, 0, n6 - n17, n14, true);
            }
            if ((n5 & 4) != 0) {
                this.drawImage(image, graphics, n + n3 - n21, n2, n + n3, n2 + n18, n6 - n17, 0, n6, n14);
            }
            if ((n5 & 0x20) != 0) {
                this.drawChunk(image, graphics, bl, n + n3 - n21, n2 + n18, n + n3, n2 + n4 - n20, n6 - n17, n14, n6, n7 - n16, false);
            }
            if ((n5 & 0x40) != 0) {
                this.drawImage(image, graphics, n + n3 - n21, n2 + n4 - n20, n + n3, n2 + n4, n6 - n17, n7 - n16, n6, n7);
            }
            if ((n5 & 0x80) != 0) {
                this.drawChunk(image, graphics, bl, n + n19, n2 + n4 - n20, n + n3 - n21, n2 + n4, n15, n7 - n16, n6 - n17, n7, true);
            }
            if ((n5 & 0x100) != 0) {
                this.drawImage(image, graphics, n, n2 + n4 - n20, n + n19, n2 + n4, 0, n7 - n16, n15, n7);
            }
            if ((n5 & 0x10) != 0) {
                this.drawImage(image, graphics, n + n19, n2 + n18, n + n3 - n21, n2 + n4 - n20, n15, n14, n6 - n17, n7 - n16);
            }
        }
    }

    private void drawImage(Image image, Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (n3 - n <= 0 || n4 - n2 <= 0 || n7 - n5 <= 0 || n8 - n6 <= 0) {
            return;
        }
        graphics.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, null);
    }

    private void drawChunk(Image image, Graphics graphics, boolean bl, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl2) {
        if (n3 - n <= 0 || n4 - n2 <= 0 || n7 - n5 <= 0 || n8 - n6 <= 0) {
            return;
        }
        if (bl) {
            graphics.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, null);
        } else {
            int n9;
            int n10;
            int n11 = n7 - n5;
            int n12 = n8 - n6;
            if (bl2) {
                n10 = n11;
                n9 = 0;
            } else {
                n10 = 0;
                n9 = n12;
            }
            while (n < n3 && n2 < n4) {
                int n13 = Math.min(n3, n + n11);
                int n14 = Math.min(n4, n2 + n12);
                graphics.drawImage(image, n, n2, n13, n14, n5, n6, n5 + n13 - n, n6 + n14 - n2, null);
                n += n10;
                n2 += n9;
            }
        }
    }

    protected Image createImage(Component component, int n, int n2, GraphicsConfiguration graphicsConfiguration, Object[] objectArray) {
        if (graphicsConfiguration == null) {
            return new BufferedImage(n, n2, 2);
        }
        return graphicsConfiguration.createCompatibleImage(n, n2, 3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PaintType {
        CENTER,
        TILE,
        PAINT9_STRETCH,
        PAINT9_TILE;

    }
}

