/*************************************************************************
 *
 *  $RCSfile: Factory.java,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2003/06/30 15:38:02 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  the BSD license.
 *  
 *  Copyright (c) 2003 by Sun Microsystems, Inc.
 *  All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *  1. Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *  3. Neither the name of Sun Microsystems, Inc. nor the names of its
 *     contributors may be used to endorse or promote products derived
 *     from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *  FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 *  COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 *  BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 *  OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 *  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
 *  TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 *  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *     
 *************************************************************************/

package OfficeDev.samples.Filter;

import com.sun.star.lib.uno.helper.WeakBase;
import com.sun.star.registry.XRegistryKey;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XSingleServiceFactory;
import com.sun.star.lang.XInitialization;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.Type;

/*-************************************************************************
  @title        implements a filter to import pure ansi text files
  @description  This filter can use an existing In/OutputStream of given
                MediaDescriptor or use an existing URL instead of that
                to open the file directly. But for second case the local
                file system will be used only.
                There is no support for remote.
 ************************************************************************-*/

public class Factory extends WeakBase
                     implements com.sun.star.lang.XServiceInfo,
                                com.sun.star.lang.XSingleServiceFactory
{
    //______________________________
    // const
    private static final String SERVICENAME = "com.sun.star.comp.ansifilter.Factory";

    //______________________________
    // member
    private com.sun.star.lang.XMultiServiceFactory m_xSMGR;

    //______________________________
    // ctor
    /**
     * We need this sevice manager to be able to initialize
     * any new created filter instance (we are a factory!)
     * with this reference. Because may this filter need
     * it too, to create own services.
     */
    public Factory( com.sun.star.lang.XMultiServiceFactory xSMGR )
    {
        m_xSMGR = xSMGR;
    }

    //______________________________
    // interface XServiceInfo

    /**
     * This method returns an array of all supported service names.
     *
     * @return Array of supported service names.
     */
    public String[] getSupportedServiceNames()
    {
        String[] lNames = new String[1];
        lNames[0] = SERVICENAME;
        return lNames;
    }

    /**
     * This method returns true, if the given service will be
     * supported by this component.
     *
     * @param sService
     *  the requested service name
     *
     * @return True, if the given service name will be supported;
     *         False otherwhise.
     */
    public boolean supportsService( String sService )
    {
        return ( sService.equals( SERVICENAME ) );
    }

    /**
        * Return the real class name of the component
        *
        * @return Class name of the component.
        */
    public String getImplementationName()
    {
        return Factory.class.getName();
    }

    //______________________________
    // interface XSingleServiceFactory

    /**
     * We are invite to create a new filter instance.
     *
     * @return a valid filter object
     */
    public java.lang.Object createInstance() throws com.sun.star.uno.Exception
    {
        return createInstanceWithArguments( new Object[0] );
    }

    /**
     * We are invite to create a new filter instance.
     * And we must initialize it with given arguments too.
     *
     * @param lArguments
     *          list of optional arguments to initialize the new created filter
     *
     * @return a valid and right initialized filter object
     */
    public java.lang.Object createInstanceWithArguments( Object[] lArguments ) throws com.sun.star.uno.Exception
    {
        AsciiReplaceFilter aFilter = null;
        synchronized(this)
        {
            aFilter = new AsciiReplaceFilter(m_xSMGR);
        }
        com.sun.star.lang.XInitialization xInit = (com.sun.star.lang.XInitialization)UnoRuntime.queryInterface(
            com.sun.star.lang.XInitialization.class,
            aFilter);
        xInit.initialize(lArguments);
        return aFilter;
    }

    //______________________________
    // component helper

    /**
     * Gives a factory for creating the service.
     * This method is called by the <code>JavaLoader</code>
     *
     * @param sImplementationName
     *  The implementation name of the component.
     *
     * @param xSMGR
     *  The service manager, who gives access to every
     *  known service.
     *
     * @param xRegistryKey
     *  Makes structural information (except regarding tree
     *  structures) of a single registry key accessible.
     *
     * @return Returns a <code>XSingleServiceFactory</code> for
     *         creating the component.
     *
     * @see com.sun.star.comp.loader.JavaLoader
     */
    public static com.sun.star.lang.XSingleServiceFactory __getServiceFactory( String                                 sImplementationName ,
                                                                               com.sun.star.lang.XMultiServiceFactory xSMGR               ,
                                                                               com.sun.star.registry.XRegistryKey     xRegistryKey        )
    {
        com.sun.star.lang.XSingleServiceFactory xSingleFactory = null;
        if (sImplementationName.equals(AsciiReplaceFilter.class.getName()))
            xSingleFactory = new Factory(xSMGR);
        return xSingleFactory;
    }

    /**
     * Writes the service information into the given registry key.
     * This method is called by the <code>JavaLoader</code>.
     *
     * @param xRegistryKey
     *  Makes structural information (except regarding tree
     *  structures) of a single registry key accessible.
     *
     * @return returns true if the operation succeeded
     *
     * @see com.sun.star.comp.loader.JavaLoader
     */
    public static boolean __writeRegistryServiceInfo( com.sun.star.registry.XRegistryKey xRootKey )
    {
        boolean bRegistered = false;
        try
        {
            com.sun.star.registry.XRegistryKey xNewKey = xRootKey.createKey("/" + AsciiReplaceFilter.class.getName() + "/UNO/SERVICES");
            xNewKey.createKey(AsciiReplaceFilter.SERVICENAME_IMPORTFILTER);
            xNewKey.createKey(AsciiReplaceFilter.SERVICENAME_EXPORTFILTER);
            bRegistered = true;
  	    }
        catch (Exception ex)
        {
  	    }
        return bRegistered;
    }
}
