/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.Adjustable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.ScrollPane;
import java.awt.ScrollPaneAdjustable;
import java.awt.peer.ScrollPanePeer;
import sun.awt.DebugHelper;
import sun.awt.PeerEvent;
import sun.awt.motif.MComponentPeer;
import sun.awt.motif.MPanelPeer;
import sun.awt.motif.MToolkit;

class MScrollPanePeer
extends MPanelPeer
implements ScrollPanePeer {
    private static final DebugHelper dbg = DebugHelper.create(MScrollPanePeer.class);
    static final int UNIT_INCREMENT = 0;
    static final int BLOCK_INCREMENT = 1;
    boolean ignore;
    static final int MARGIN = 1;
    static final int SCROLLBAR = 16;
    int hsbSpace;
    int vsbSpace;
    int vval;
    int hval;
    int vmax;
    int hmax;

    native void create(MComponentPeer var1);

    private static native void initIDs();

    MScrollPanePeer(Component component) {
        this.init(component);
        this.scrollPaneInit();
    }

    MScrollPanePeer(Component component, Object object) {
        this.init(component, object);
        this.scrollPaneInit();
    }

    void scrollPaneInit() {
        Adjustable adjustable;
        this.ignore = false;
        ScrollPane scrollPane = (ScrollPane)this.target;
        Adjustable adjustable2 = scrollPane.getVAdjustable();
        if (adjustable2 != null) {
            this.pSetIncrement(1, 0, adjustable2.getUnitIncrement());
        }
        if ((adjustable = scrollPane.getHAdjustable()) != null) {
            this.pSetIncrement(0, 0, adjustable.getUnitIncrement());
        }
        super.pSetScrollbarBackground(scrollPane.getBackground());
    }

    public void setScrollChild(MComponentPeer mComponentPeer) {
        this.pSetScrollChild(mComponentPeer);
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.pSetScrollbarBackground(color);
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.pSetInnerForeground(color);
    }

    native void pSetScrollChild(MComponentPeer var1);

    native void pSetIncrement(int var1, int var2, int var3);

    native int pGetScrollbarSpace(int var1);

    native int pGetBlockIncrement(int var1);

    native Insets pInsets(int var1, int var2, int var3, int var4);

    native int pGetShadow();

    public int getHScrollbarHeight() {
        ScrollPane scrollPane = (ScrollPane)this.target;
        if (scrollPane.getScrollbarDisplayPolicy() == 2) {
            return 0;
        }
        return this.pGetScrollbarSpace(0);
    }

    public int getVScrollbarWidth() {
        ScrollPane scrollPane = (ScrollPane)this.target;
        if (scrollPane.getScrollbarDisplayPolicy() == 2) {
            return 0;
        }
        return this.pGetScrollbarSpace(1);
    }

    public Insets insets() {
        ScrollPane scrollPane = (ScrollPane)this.target;
        Dimension dimension = scrollPane.size();
        Component component = this.getScrollChild();
        Dimension dimension2 = component != null ? component.size() : new Dimension(0, 0);
        return this.pInsets(dimension.width, dimension.height, dimension2.width, dimension2.height);
    }

    public void setUnitIncrement(Adjustable adjustable, int n) {
        ScrollPane scrollPane = (ScrollPane)this.target;
        if (scrollPane.getScrollbarDisplayPolicy() != 2) {
            this.pSetIncrement(adjustable.getOrientation(), 0, n);
        }
    }

    public void setValue(Adjustable adjustable, int n) {
        if (!this.ignore) {
            Component component = this.getScrollChild();
            if (component == null) {
                return;
            }
            Point point = component.getLocation();
            switch (adjustable.getOrientation()) {
                case 1: {
                    this.setScrollPosition(-point.x, n);
                    break;
                }
                case 0: {
                    this.setScrollPosition(n, -point.y);
                }
            }
        }
    }

    public native void setScrollPosition(int var1, int var2);

    public void childResized(int n, int n2) {
        if (((ScrollPane)this.target).getScrollbarDisplayPolicy() != 2) {
            ScrollPane scrollPane = (ScrollPane)this.target;
            Adjustable adjustable = scrollPane.getVAdjustable();
            Adjustable adjustable2 = scrollPane.getHAdjustable();
            this.pSetIncrement(1, 0, adjustable.getUnitIncrement());
            this.pSetIncrement(0, 0, adjustable2.getUnitIncrement());
            this.pSetIncrement(1, 1, adjustable.getBlockIncrement());
            this.pSetIncrement(0, 1, adjustable2.getBlockIncrement());
        }
    }

    private void postScrollEvent(int n, int n2, int n3, boolean bl) {
        Adjustor adjustor = new Adjustor(n, n2, n3, bl);
        MToolkit.executeOnEventHandlerThread(new ScrollEvent(this.target, adjustor));
    }

    native void setTypedValue(ScrollPaneAdjustable var1, int var2, int var3);

    private Component getScrollChild() {
        ScrollPane scrollPane = (ScrollPane)this.target;
        Component component = null;
        try {
            component = scrollPane.getComponent(0);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(Graphics graphics) {
        Graphics graphics2;
        int n;
        ScrollPane scrollPane = (ScrollPane)this.target;
        Dimension dimension = scrollPane.size();
        Color color = scrollPane.getBackground();
        Color color2 = scrollPane.getForeground();
        Point point = scrollPane.getScrollPosition();
        Component component = this.getScrollChild();
        Dimension dimension2 = component != null ? component.size() : new Dimension(0, 0);
        int n2 = scrollPane.getScrollbarDisplayPolicy();
        switch (n2) {
            case 2: {
                this.vsbSpace = 0;
                this.hsbSpace = 0;
                break;
            }
            case 1: {
                this.vsbSpace = 16;
                this.hsbSpace = 16;
                break;
            }
            case 0: {
                this.hsbSpace = dimension2.width <= dimension.width - 2 ? 0 : 16;
                int n3 = this.vsbSpace = dimension2.height <= dimension.height - 2 ? 0 : 16;
                if (this.hsbSpace == 0 && this.vsbSpace != 0) {
                    int n4 = this.hsbSpace = dimension2.width <= dimension.width - 16 - 2 ? 0 : 16;
                }
                if (this.vsbSpace != 0 || this.hsbSpace == 0) break;
                this.vsbSpace = dimension2.height <= dimension.height - 16 - 2 ? 0 : 16;
            }
        }
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        if (this.vsbSpace > 0) {
            n10 = 0;
            n12 = dimension.height - 2 - this.hsbSpace;
            n8 = Math.max(dimension2.height - n12, 0);
            n6 = point.y;
        }
        if (this.hsbSpace > 0) {
            n9 = 0;
            n11 = dimension.width - 2 - this.vsbSpace;
            n7 = Math.max(dimension2.width - n11, 0);
            n5 = point.x;
        }
        int n13 = dimension.width - this.vsbSpace;
        int n14 = dimension.height - this.hsbSpace;
        graphics.setColor(color);
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        if (this.hsbSpace > 0) {
            n = dimension.width - this.vsbSpace;
            graphics.fillRect(1, dimension.height - 16 - 3, n - 1, 13);
            graphics2 = graphics.create();
            try {
                graphics2.translate(0, dimension.height - 14);
                this.drawScrollbar(graphics2, color, 14, n, n9, n7, n5, n11, true);
            }
            finally {
                graphics2.dispose();
            }
        }
        if (this.vsbSpace > 0) {
            n = dimension.height - this.hsbSpace;
            graphics.fillRect(dimension.width - 16 - 3, 1, 13, n - 1);
            graphics2 = graphics.create();
            try {
                graphics2.translate(dimension.width - 14, 0);
                this.drawScrollbar(graphics2, color, 14, n, n10, n8, n6, n12, false);
            }
            finally {
                graphics2.dispose();
            }
        }
        this.draw3DRect(graphics, color, 0, 0, n13 - 1, n14 - 1, false);
        this.target.print(graphics);
        scrollPane.printComponents(graphics);
    }

    public void restack() {
    }

    static {
        MScrollPanePeer.initIDs();
    }

    class Adjustor
    implements Runnable {
        int orient;
        int type;
        int pos;
        boolean isAdjusting;

        Adjustor(int n, int n2, int n3, boolean bl) {
            this.orient = n;
            this.type = n2;
            this.pos = n3;
            this.isAdjusting = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ScrollPane scrollPane = (ScrollPane)MScrollPanePeer.this.target;
            ScrollPaneAdjustable scrollPaneAdjustable = null;
            if (this.orient == 1) {
                scrollPaneAdjustable = (ScrollPaneAdjustable)scrollPane.getVAdjustable();
            } else if (this.orient == 0) {
                scrollPaneAdjustable = (ScrollPaneAdjustable)scrollPane.getHAdjustable();
            } else {
                dbg;
            }
            if (scrollPaneAdjustable == null) {
                return;
            }
            int n = scrollPaneAdjustable.getValue();
            switch (this.type) {
                case 2: {
                    n -= scrollPaneAdjustable.getUnitIncrement();
                    break;
                }
                case 1: {
                    n += scrollPaneAdjustable.getUnitIncrement();
                    break;
                }
                case 3: {
                    n -= scrollPaneAdjustable.getBlockIncrement();
                    break;
                }
                case 4: {
                    n += scrollPaneAdjustable.getBlockIncrement();
                    break;
                }
                case 5: {
                    n = this.pos;
                    break;
                }
                default: {
                    dbg;
                    return;
                }
            }
            n = Math.max(scrollPaneAdjustable.getMinimum(), n);
            n = Math.min(scrollPaneAdjustable.getMaximum(), n);
            try {
                MScrollPanePeer.this.ignore = true;
                scrollPaneAdjustable.setValueIsAdjusting(this.isAdjusting);
                MScrollPanePeer.this.setTypedValue(scrollPaneAdjustable, n, this.type);
            }
            finally {
                MScrollPanePeer.this.ignore = false;
            }
        }
    }

    class ScrollEvent
    extends PeerEvent {
        ScrollEvent(Object object, Runnable runnable) {
            super(object, runnable, 0L);
        }

        public PeerEvent coalesceEvents(PeerEvent peerEvent) {
            dbg;
            if (peerEvent instanceof ScrollEvent) {
                return peerEvent;
            }
            return null;
        }
    }
}

