/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.DataBuffer;

public final class DataBufferDouble
extends DataBuffer {
    double[][] bankdata;
    double[] data;

    public DataBufferDouble(int n) {
        super(5, n);
        this.data = new double[n];
        this.bankdata = new double[1][];
        this.bankdata[0] = this.data;
    }

    public DataBufferDouble(int n, int n2) {
        super(5, n, n2);
        this.bankdata = new double[n2][];
        for (int i = 0; i < n2; ++i) {
            this.bankdata[i] = new double[n];
        }
        this.data = this.bankdata[0];
    }

    public DataBufferDouble(double[] dArray, int n) {
        super(5, n);
        this.data = dArray;
        this.bankdata = new double[1][];
        this.bankdata[0] = this.data;
    }

    public DataBufferDouble(double[] dArray, int n, int n2) {
        super(5, n, 1, n2);
        this.data = dArray;
        this.bankdata = new double[1][];
        this.bankdata[0] = this.data;
    }

    public DataBufferDouble(double[][] dArray, int n) {
        super(5, n, dArray.length);
        this.bankdata = (double[][])dArray.clone();
        this.data = this.bankdata[0];
    }

    public DataBufferDouble(double[][] dArray, int n, int[] nArray) {
        super(5, n, dArray.length, nArray);
        this.bankdata = (double[][])dArray.clone();
        this.data = this.bankdata[0];
    }

    public double[] getData() {
        return this.data;
    }

    public double[] getData(int n) {
        return this.bankdata[n];
    }

    public double[][] getBankData() {
        return (double[][])this.bankdata.clone();
    }

    public int getElem(int n) {
        return (int)this.data[n + this.offset];
    }

    public int getElem(int n, int n2) {
        return (int)this.bankdata[n][n2 + this.offsets[n]];
    }

    public void setElem(int n, int n2) {
        this.data[n + this.offset] = n2;
    }

    public void setElem(int n, int n2, int n3) {
        this.bankdata[n][n2 + this.offsets[n]] = n3;
    }

    public float getElemFloat(int n) {
        return (float)this.data[n + this.offset];
    }

    public float getElemFloat(int n, int n2) {
        return (float)this.bankdata[n][n2 + this.offsets[n]];
    }

    public void setElemFloat(int n, float f) {
        this.data[n + this.offset] = f;
    }

    public void setElemFloat(int n, int n2, float f) {
        this.bankdata[n][n2 + this.offsets[n]] = f;
    }

    public double getElemDouble(int n) {
        return this.data[n + this.offset];
    }

    public double getElemDouble(int n, int n2) {
        return this.bankdata[n][n2 + this.offsets[n]];
    }

    public void setElemDouble(int n, double d) {
        this.data[n + this.offset] = d;
    }

    public void setElemDouble(int n, int n2, double d) {
        this.bankdata[n][n2 + this.offsets[n]] = d;
    }
}

