/*
 * Decompiled with CFR 0.152.
 */
package sun.org.mozilla.javascript.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import sun.org.mozilla.javascript.internal.FunctionObject;
import sun.org.mozilla.javascript.internal.Kit;
import sun.org.mozilla.javascript.internal.RhinoException;
import sun.org.mozilla.javascript.internal.Scriptable;
import sun.org.mozilla.javascript.internal.ScriptableObject;

public final class LazilyLoadedCtor {
    private static Method getter;
    private static Method setter;
    private String ctorName;
    private String className;
    private boolean sealed;
    private boolean isReplaced;

    public LazilyLoadedCtor(ScriptableObject scriptableObject, String string, String string2, boolean bl) {
        this.className = string2;
        this.ctorName = string;
        this.sealed = bl;
        if (getter == null) {
            Method[] methodArray = FunctionObject.getMethodList(this.getClass());
            getter = FunctionObject.findSingleMethod(methodArray, "getProperty");
            setter = FunctionObject.findSingleMethod(methodArray, "setProperty");
        }
        scriptableObject.defineProperty(string, this, getter, setter, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getProperty(ScriptableObject scriptableObject) {
        ScriptableObject scriptableObject2 = scriptableObject;
        synchronized (scriptableObject2) {
            if (!this.isReplaced) {
                boolean bl = false;
                Class clazz = Kit.classOrNull(this.className);
                if (clazz == null) {
                    bl = true;
                } else {
                    try {
                        ScriptableObject.defineClass(scriptableObject, clazz, this.sealed);
                        this.isReplaced = true;
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        Throwable throwable = invocationTargetException.getTargetException();
                        if (throwable instanceof RuntimeException) {
                            throw (RuntimeException)throwable;
                        }
                        bl = true;
                    }
                    catch (RhinoException rhinoException) {
                        bl = true;
                    }
                    catch (InstantiationException instantiationException) {
                        bl = true;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        bl = true;
                    }
                    catch (SecurityException securityException) {
                        bl = true;
                    }
                    catch (LinkageError linkageError) {
                        bl = true;
                    }
                }
                if (bl) {
                    scriptableObject.delete(this.ctorName);
                    return Scriptable.NOT_FOUND;
                }
            }
        }
        return scriptableObject.get(this.ctorName, (Scriptable)scriptableObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object setProperty(ScriptableObject scriptableObject, Object object) {
        ScriptableObject scriptableObject2 = scriptableObject;
        synchronized (scriptableObject2) {
            this.isReplaced = true;
            return object;
        }
    }
}

