/*
 * Decompiled with CFR 0.152.
 */
package sun.swing.plaf.synth;

import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.UIDefaults;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthGraphicsUtils;
import javax.swing.plaf.synth.SynthPainter;
import javax.swing.plaf.synth.SynthStyle;

public class DefaultSynthStyle
extends SynthStyle
implements Cloneable {
    private static final Object PENDING = new String("Pending");
    private boolean opaque;
    private Insets insets;
    private StateInfo[] states;
    private Map data;
    private Font font;
    private SynthGraphicsUtils synthGraphics;
    private SynthPainter painter;

    public DefaultSynthStyle() {
    }

    public DefaultSynthStyle(DefaultSynthStyle defaultSynthStyle) {
        this.opaque = defaultSynthStyle.opaque;
        if (defaultSynthStyle.insets != null) {
            this.insets = new Insets(defaultSynthStyle.insets.top, defaultSynthStyle.insets.left, defaultSynthStyle.insets.bottom, defaultSynthStyle.insets.right);
        }
        if (defaultSynthStyle.states != null) {
            this.states = new StateInfo[defaultSynthStyle.states.length];
            for (int i = defaultSynthStyle.states.length - 1; i >= 0; --i) {
                this.states[i] = (StateInfo)defaultSynthStyle.states[i].clone();
            }
        }
        if (defaultSynthStyle.data != null) {
            this.data = new HashMap();
            this.data.putAll(defaultSynthStyle.data);
        }
        this.font = defaultSynthStyle.font;
        this.synthGraphics = defaultSynthStyle.synthGraphics;
        this.painter = defaultSynthStyle.painter;
    }

    public DefaultSynthStyle(Insets insets, boolean bl, StateInfo[] stateInfoArray, Map map) {
        this.insets = insets;
        this.opaque = bl;
        this.states = stateInfoArray;
        this.data = map;
    }

    public Color getColor(SynthContext synthContext, ColorType colorType) {
        return this.getColor(synthContext.getComponent(), synthContext.getRegion(), synthContext.getComponentState(), colorType);
    }

    public Color getColor(JComponent jComponent, Region region, int n, ColorType colorType) {
        Color color;
        if (!region.isSubregion() && n == 1) {
            if (colorType == ColorType.BACKGROUND) {
                return jComponent.getBackground();
            }
            if (colorType == ColorType.FOREGROUND) {
                return jComponent.getForeground();
            }
            if (colorType == ColorType.TEXT_FOREGROUND && !((color = jComponent.getForeground()) instanceof UIResource)) {
                return color;
            }
        }
        if ((color = this.getColorForState(jComponent, region, n, colorType)) == null) {
            if (colorType == ColorType.BACKGROUND || colorType == ColorType.TEXT_BACKGROUND) {
                return jComponent.getBackground();
            }
            if (colorType == ColorType.FOREGROUND || colorType == ColorType.TEXT_FOREGROUND) {
                return jComponent.getForeground();
            }
        }
        return color;
    }

    protected Color getColorForState(SynthContext synthContext, ColorType colorType) {
        return this.getColorForState(synthContext.getComponent(), synthContext.getRegion(), synthContext.getComponentState(), colorType);
    }

    protected Color getColorForState(JComponent jComponent, Region region, int n, ColorType colorType) {
        Color color;
        StateInfo stateInfo = this.getStateInfo(n);
        if (stateInfo != null && (color = stateInfo.getColor(colorType)) != null) {
            return color;
        }
        if ((stateInfo == null || stateInfo.getComponentState() != 0) && (stateInfo = this.getStateInfo(0)) != null) {
            return stateInfo.getColor(colorType);
        }
        return null;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Font getFont(SynthContext synthContext) {
        return this.getFont(synthContext.getComponent(), synthContext.getRegion(), synthContext.getComponentState());
    }

    public Font getFont(JComponent jComponent, Region region, int n) {
        if (!region.isSubregion() && n == 1) {
            return jComponent.getFont();
        }
        Font font = jComponent.getFont();
        if (font != null && !(font instanceof UIResource)) {
            return font;
        }
        return this.getFontForState(jComponent, region, n);
    }

    protected Font getFontForState(JComponent jComponent, Region region, int n) {
        Font font;
        if (jComponent == null) {
            return this.font;
        }
        StateInfo stateInfo = this.getStateInfo(n);
        if (stateInfo != null && (font = stateInfo.getFont()) != null) {
            return font;
        }
        if ((stateInfo == null || stateInfo.getComponentState() != 0) && (stateInfo = this.getStateInfo(0)) != null && (font = stateInfo.getFont()) != null) {
            return font;
        }
        return this.font;
    }

    protected Font getFontForState(SynthContext synthContext) {
        return this.getFontForState(synthContext.getComponent(), synthContext.getRegion(), synthContext.getComponentState());
    }

    public void setGraphicsUtils(SynthGraphicsUtils synthGraphicsUtils) {
        this.synthGraphics = synthGraphicsUtils;
    }

    public SynthGraphicsUtils getGraphicsUtils(SynthContext synthContext) {
        if (this.synthGraphics == null) {
            return super.getGraphicsUtils(synthContext);
        }
        return this.synthGraphics;
    }

    public void setInsets(Insets insets) {
        this.insets = insets;
    }

    public Insets getInsets(SynthContext synthContext, Insets insets) {
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        if (this.insets != null) {
            insets.left = this.insets.left;
            insets.right = this.insets.right;
            insets.top = this.insets.top;
            insets.bottom = this.insets.bottom;
        } else {
            insets.bottom = 0;
            insets.top = 0;
            insets.right = 0;
            insets.left = 0;
        }
        return insets;
    }

    public void setPainter(SynthPainter synthPainter) {
        this.painter = synthPainter;
    }

    public SynthPainter getPainter(SynthContext synthContext) {
        return this.painter;
    }

    public void setOpaque(boolean bl) {
        this.opaque = bl;
    }

    public boolean isOpaque(SynthContext synthContext) {
        return this.opaque;
    }

    public void setData(Map map) {
        this.data = map;
    }

    public Map getData() {
        return this.data;
    }

    public Object get(SynthContext synthContext, Object object) {
        StateInfo stateInfo = this.getStateInfo(synthContext.getComponentState());
        if (stateInfo != null && stateInfo.getData() != null && this.getKeyFromData(stateInfo.getData(), object) != null) {
            return this.getKeyFromData(stateInfo.getData(), object);
        }
        stateInfo = this.getStateInfo(0);
        if (stateInfo != null && stateInfo.getData() != null && this.getKeyFromData(stateInfo.getData(), object) != null) {
            return this.getKeyFromData(stateInfo.getData(), object);
        }
        if (this.getKeyFromData(this.data, object) != null) {
            return this.getKeyFromData(this.data, object);
        }
        return this.getDefaultValue(synthContext, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getKeyFromData(Map map, Object object) {
        Object object2 = null;
        if (map != null) {
            Map map2 = map;
            synchronized (map2) {
                object2 = map.get(object);
            }
            while (object2 == PENDING) {
                map2 = map;
                synchronized (map2) {
                    try {
                        map.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    object2 = map.get(object);
                }
            }
            if (object2 instanceof UIDefaults.LazyValue) {
                map2 = map;
                synchronized (map2) {
                    map.put(object, PENDING);
                }
                object2 = ((UIDefaults.LazyValue)object2).createValue(null);
                map2 = map;
                synchronized (map2) {
                    map.put(object, object2);
                    map.notifyAll();
                }
            }
        }
        return object2;
    }

    public Object getDefaultValue(SynthContext synthContext, Object object) {
        return super.get(synthContext, object);
    }

    public Object clone() {
        DefaultSynthStyle defaultSynthStyle;
        try {
            defaultSynthStyle = (DefaultSynthStyle)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
        if (this.states != null) {
            defaultSynthStyle.states = new StateInfo[this.states.length];
            for (int i = this.states.length - 1; i >= 0; --i) {
                defaultSynthStyle.states[i] = (StateInfo)this.states[i].clone();
            }
        }
        if (this.data != null) {
            defaultSynthStyle.data = new HashMap();
            defaultSynthStyle.data.putAll(this.data);
        }
        return defaultSynthStyle;
    }

    public DefaultSynthStyle addTo(DefaultSynthStyle defaultSynthStyle) {
        if (this.insets != null) {
            defaultSynthStyle.insets = this.insets;
        }
        if (this.font != null) {
            defaultSynthStyle.font = this.font;
        }
        if (this.painter != null) {
            defaultSynthStyle.painter = this.painter;
        }
        if (this.synthGraphics != null) {
            defaultSynthStyle.synthGraphics = this.synthGraphics;
        }
        defaultSynthStyle.opaque = this.opaque;
        if (this.states != null) {
            if (defaultSynthStyle.states == null) {
                defaultSynthStyle.states = new StateInfo[this.states.length];
                for (int i = this.states.length - 1; i >= 0; --i) {
                    if (this.states[i] == null) continue;
                    defaultSynthStyle.states[i] = (StateInfo)this.states[i].clone();
                }
            } else {
                int n;
                int n2;
                int n3;
                int n4 = 0;
                int n5 = 0;
                int n6 = defaultSynthStyle.states.length;
                for (int i = this.states.length - 1; i >= 0; --i) {
                    n3 = this.states[i].getComponentState();
                    n2 = 0;
                    for (n = n6 - 1 - n5; n >= 0; --n) {
                        if (n3 != defaultSynthStyle.states[n].getComponentState()) continue;
                        defaultSynthStyle.states[n] = this.states[i].addTo(defaultSynthStyle.states[n]);
                        StateInfo stateInfo = defaultSynthStyle.states[n6 - 1 - n5];
                        defaultSynthStyle.states[n6 - 1 - n5] = defaultSynthStyle.states[n];
                        defaultSynthStyle.states[n] = stateInfo;
                        ++n5;
                        n2 = 1;
                        break;
                    }
                    if (n2 != 0) continue;
                    ++n4;
                }
                if (n4 != 0) {
                    StateInfo[] stateInfoArray = new StateInfo[n4 + n6];
                    n3 = n6;
                    System.arraycopy(defaultSynthStyle.states, 0, stateInfoArray, 0, n6);
                    for (n2 = this.states.length - 1; n2 >= 0; --n2) {
                        n = this.states[n2].getComponentState();
                        boolean bl = false;
                        for (int i = n6 - 1; i >= 0; --i) {
                            if (n != defaultSynthStyle.states[i].getComponentState()) continue;
                            bl = true;
                            break;
                        }
                        if (bl) continue;
                        stateInfoArray[n3++] = (StateInfo)this.states[n2].clone();
                    }
                    defaultSynthStyle.states = stateInfoArray;
                }
            }
        }
        if (this.data != null) {
            if (defaultSynthStyle.data == null) {
                defaultSynthStyle.data = new HashMap();
            }
            defaultSynthStyle.data.putAll(this.data);
        }
        return defaultSynthStyle;
    }

    public void setStateInfo(StateInfo[] stateInfoArray) {
        this.states = stateInfoArray;
    }

    public StateInfo[] getStateInfo() {
        return this.states;
    }

    public StateInfo getStateInfo(int n) {
        if (this.states != null) {
            int n2 = 0;
            int n3 = -1;
            int n4 = -1;
            if (n == 0) {
                for (int i = this.states.length - 1; i >= 0; --i) {
                    if (this.states[i].getComponentState() != 0) continue;
                    return this.states[i];
                }
                return null;
            }
            for (int i = this.states.length - 1; i >= 0; --i) {
                int n5 = this.states[i].getComponentState();
                if (n5 == 0) {
                    if (n4 != -1) continue;
                    n4 = i;
                    continue;
                }
                if ((n & n5) != n5) continue;
                int n6 = n5;
                n6 -= (0xAAAAAAAA & n6) >>> 1;
                n6 = (n6 & 0x33333333) + (n6 >>> 2 & 0x33333333);
                n6 = n6 + (n6 >>> 4) & 0xF0F0F0F;
                n6 += n6 >>> 8;
                n6 += n6 >>> 16;
                if ((n6 &= 0xFF) <= n2) continue;
                n3 = i;
                n2 = n6;
            }
            if (n3 != -1) {
                return this.states[n3];
            }
            if (n4 != -1) {
                return this.states[n4];
            }
        }
        return null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString()).append(',');
        stringBuffer.append("data=").append(this.data).append(',');
        stringBuffer.append("font=").append(this.font).append(',');
        stringBuffer.append("insets=").append(this.insets).append(',');
        stringBuffer.append("synthGraphics=").append(this.synthGraphics).append(',');
        stringBuffer.append("painter=").append(this.painter).append(',');
        StateInfo[] stateInfoArray = this.getStateInfo();
        if (stateInfoArray != null) {
            stringBuffer.append("states[");
            for (int i = 0; i < stateInfoArray.length; ++i) {
                stringBuffer.append(stateInfoArray[i].toString()).append(',');
            }
            stringBuffer.append(']').append(',');
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }

    public static class StateInfo {
        private Map data;
        private Font font;
        private Color[] colors;
        private int state;

        public StateInfo() {
        }

        public StateInfo(int n, Font font, Color[] colorArray) {
            this.state = n;
            this.font = font;
            this.colors = colorArray;
        }

        public StateInfo(StateInfo stateInfo) {
            this.state = stateInfo.state;
            this.font = stateInfo.font;
            if (stateInfo.data != null) {
                if (this.data == null) {
                    this.data = new HashMap();
                }
                this.data.putAll(stateInfo.data);
            }
            if (stateInfo.colors != null) {
                this.colors = new Color[stateInfo.colors.length];
                System.arraycopy(stateInfo.colors, 0, this.colors, 0, stateInfo.colors.length);
            }
        }

        public Map getData() {
            return this.data;
        }

        public void setData(Map map) {
            this.data = map;
        }

        public void setFont(Font font) {
            this.font = font;
        }

        public Font getFont() {
            return this.font;
        }

        public void setColors(Color[] colorArray) {
            this.colors = colorArray;
        }

        public Color[] getColors() {
            return this.colors;
        }

        public Color getColor(ColorType colorType) {
            int n;
            if (this.colors != null && (n = colorType.getID()) < this.colors.length) {
                return this.colors[n];
            }
            return null;
        }

        public StateInfo addTo(StateInfo stateInfo) {
            if (this.font != null) {
                stateInfo.font = this.font;
            }
            if (this.data != null) {
                if (stateInfo.data == null) {
                    stateInfo.data = new HashMap();
                }
                stateInfo.data.putAll(this.data);
            }
            if (this.colors != null) {
                if (stateInfo.colors == null) {
                    stateInfo.colors = new Color[this.colors.length];
                    System.arraycopy(this.colors, 0, stateInfo.colors, 0, this.colors.length);
                } else {
                    if (stateInfo.colors.length < this.colors.length) {
                        Color[] colorArray = stateInfo.colors;
                        stateInfo.colors = new Color[this.colors.length];
                        System.arraycopy(colorArray, 0, stateInfo.colors, 0, colorArray.length);
                    }
                    for (int i = this.colors.length - 1; i >= 0; --i) {
                        if (this.colors[i] == null) continue;
                        stateInfo.colors[i] = this.colors[i];
                    }
                }
            }
            return stateInfo;
        }

        public void setComponentState(int n) {
            this.state = n;
        }

        public int getComponentState() {
            return this.state;
        }

        private final int getMatchCount(int n) {
            n &= this.state;
            n -= (0xAAAAAAAA & n) >>> 1;
            n = (n & 0x33333333) + (n >>> 2 & 0x33333333);
            n = n + (n >>> 4) & 0xF0F0F0F;
            n += n >>> 8;
            n += n >>> 16;
            return n & 0xFF;
        }

        public Object clone() {
            return new StateInfo(this);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(super.toString()).append(',');
            stringBuffer.append("state=").append(Integer.toString(this.state)).append(',');
            stringBuffer.append("font=").append(this.font).append(',');
            if (this.colors != null) {
                stringBuffer.append("colors=").append(Arrays.asList(this.colors)).append(',');
            }
            return stringBuffer.toString();
        }
    }
}

