/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;

public final class StringBuffer
extends AbstractStringBuilder
implements Serializable,
CharSequence {
    static final long serialVersionUID = 3388685877147921107L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("value", char[].class), new ObjectStreamField("count", Integer.TYPE), new ObjectStreamField("shared", Boolean.TYPE)};

    public StringBuffer() {
        super(16);
    }

    public StringBuffer(int n) {
        super(n);
    }

    public StringBuffer(String string) {
        super(string.length() + 16);
        this.append(string);
    }

    public StringBuffer(CharSequence charSequence) {
        this(charSequence.length() + 16);
        this.append(charSequence);
    }

    public synchronized int length() {
        return this.count;
    }

    public synchronized int capacity() {
        return this.value.length;
    }

    public synchronized void ensureCapacity(int n) {
        if (n > this.value.length) {
            this.expandCapacity(n);
        }
    }

    public synchronized void trimToSize() {
        super.trimToSize();
    }

    public synchronized void setLength(int n) {
        super.setLength(n);
    }

    public synchronized char charAt(int n) {
        if (n < 0 || n >= this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        return this.value[n];
    }

    public synchronized int codePointAt(int n) {
        return super.codePointAt(n);
    }

    public synchronized int codePointBefore(int n) {
        return super.codePointBefore(n);
    }

    public synchronized int codePointCount(int n, int n2) {
        return super.codePointCount(n, n2);
    }

    public synchronized int offsetByCodePoints(int n, int n2) {
        return super.offsetByCodePoints(n, n2);
    }

    public synchronized void getChars(int n, int n2, char[] cArray, int n3) {
        super.getChars(n, n2, cArray, n3);
    }

    public synchronized void setCharAt(int n, char c) {
        if (n < 0 || n >= this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        this.value[n] = c;
    }

    public synchronized StringBuffer append(Object object) {
        super.append(String.valueOf(object));
        return this;
    }

    public synchronized StringBuffer append(String string) {
        super.append(string);
        return this;
    }

    public synchronized StringBuffer append(StringBuffer stringBuffer) {
        super.append(stringBuffer);
        return this;
    }

    public StringBuffer append(CharSequence charSequence) {
        if (charSequence == null) {
            charSequence = "null";
        }
        if (charSequence instanceof String) {
            return this.append((String)charSequence);
        }
        if (charSequence instanceof StringBuffer) {
            return this.append((StringBuffer)charSequence);
        }
        return this.append(charSequence, 0, charSequence.length());
    }

    public synchronized StringBuffer append(CharSequence charSequence, int n, int n2) {
        super.append(charSequence, n, n2);
        return this;
    }

    public synchronized StringBuffer append(char[] cArray) {
        super.append(cArray);
        return this;
    }

    public synchronized StringBuffer append(char[] cArray, int n, int n2) {
        super.append(cArray, n, n2);
        return this;
    }

    public synchronized StringBuffer append(boolean bl) {
        super.append(bl);
        return this;
    }

    public synchronized StringBuffer append(char c) {
        super.append(c);
        return this;
    }

    public synchronized StringBuffer append(int n) {
        super.append(n);
        return this;
    }

    public synchronized StringBuffer appendCodePoint(int n) {
        super.appendCodePoint(n);
        return this;
    }

    public synchronized StringBuffer append(long l) {
        super.append(l);
        return this;
    }

    public synchronized StringBuffer append(float f) {
        super.append(f);
        return this;
    }

    public synchronized StringBuffer append(double d) {
        super.append(d);
        return this;
    }

    public synchronized StringBuffer delete(int n, int n2) {
        super.delete(n, n2);
        return this;
    }

    public synchronized StringBuffer deleteCharAt(int n) {
        super.deleteCharAt(n);
        return this;
    }

    public synchronized StringBuffer replace(int n, int n2, String string) {
        super.replace(n, n2, string);
        return this;
    }

    public synchronized String substring(int n) {
        return this.substring(n, this.count);
    }

    public synchronized CharSequence subSequence(int n, int n2) {
        return super.substring(n, n2);
    }

    public synchronized String substring(int n, int n2) {
        return super.substring(n, n2);
    }

    public synchronized StringBuffer insert(int n, char[] cArray, int n2, int n3) {
        super.insert(n, cArray, n2, n3);
        return this;
    }

    public synchronized StringBuffer insert(int n, Object object) {
        super.insert(n, String.valueOf(object));
        return this;
    }

    public synchronized StringBuffer insert(int n, String string) {
        super.insert(n, string);
        return this;
    }

    public synchronized StringBuffer insert(int n, char[] cArray) {
        super.insert(n, cArray);
        return this;
    }

    public StringBuffer insert(int n, CharSequence charSequence) {
        if (charSequence == null) {
            charSequence = "null";
        }
        if (charSequence instanceof String) {
            return this.insert(n, (String)charSequence);
        }
        return this.insert(n, charSequence, 0, charSequence.length());
    }

    public synchronized StringBuffer insert(int n, CharSequence charSequence, int n2, int n3) {
        super.insert(n, charSequence, n2, n3);
        return this;
    }

    public StringBuffer insert(int n, boolean bl) {
        return this.insert(n, String.valueOf(bl));
    }

    public synchronized StringBuffer insert(int n, char c) {
        super.insert(n, c);
        return this;
    }

    public StringBuffer insert(int n, int n2) {
        return this.insert(n, String.valueOf(n2));
    }

    public StringBuffer insert(int n, long l) {
        return this.insert(n, String.valueOf(l));
    }

    public StringBuffer insert(int n, float f) {
        return this.insert(n, String.valueOf(f));
    }

    public StringBuffer insert(int n, double d) {
        return this.insert(n, String.valueOf(d));
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public synchronized int indexOf(String string, int n) {
        return String.indexOf(this.value, 0, this.count, string.toCharArray(), 0, string.length(), n);
    }

    public int lastIndexOf(String string) {
        return this.lastIndexOf(string, this.count);
    }

    public synchronized int lastIndexOf(String string, int n) {
        return String.lastIndexOf(this.value, 0, this.count, string.toCharArray(), 0, string.length(), n);
    }

    public synchronized StringBuffer reverse() {
        super.reverse();
        return this;
    }

    public synchronized String toString() {
        return new String(this.value, 0, this.count);
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("value", this.value);
        putField.put("count", this.count);
        putField.put("shared", false);
        objectOutputStream.writeFields();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        this.value = (char[])getField.get("value", null);
        this.count = getField.get("count", 0);
    }
}

