/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import sun.rmi.runtime.Log;
import sun.rmi.transport.DGCImpl;

class WeakRef
extends WeakReference {
    private int hashValue;
    private Object strongRef = null;

    public WeakRef(Object object) {
        super(object);
        this.setHashValue(object);
    }

    public WeakRef(Object object, ReferenceQueue referenceQueue) {
        super(object, referenceQueue);
        this.setHashValue(object);
    }

    public synchronized void pin() {
        if (this.strongRef == null) {
            this.strongRef = this.get();
            if (DGCImpl.dgcLog.isLoggable(Log.VERBOSE)) {
                DGCImpl.dgcLog.log(Log.VERBOSE, "strongRef = " + this.strongRef);
            }
        }
    }

    public synchronized void unpin() {
        if (this.strongRef != null) {
            if (DGCImpl.dgcLog.isLoggable(Log.VERBOSE)) {
                DGCImpl.dgcLog.log(Log.VERBOSE, "strongRef = " + this.strongRef);
            }
            this.strongRef = null;
        }
    }

    private void setHashValue(Object object) {
        this.hashValue = object != null ? System.identityHashCode(object) : 0;
    }

    public int hashCode() {
        return this.hashValue;
    }

    public boolean equals(Object object) {
        if (object instanceof WeakRef) {
            if (object == this) {
                return true;
            }
            Object t = this.get();
            return t != null && t == ((WeakRef)object).get();
        }
        return false;
    }
}

