/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import sun.nio.cs.CharsetMapping;
import sun.nio.cs.ext.ExtendedCharsets;
import sun.nio.cs.ext.SJIS;

public class SJIS_0213
extends Charset {
    static CharsetMapping mapping = CharsetMapping.get(SJIS_0213.class, (String)"sjis0213.dat");

    public SJIS_0213() {
        super("x-SJIS_0213", ExtendedCharsets.aliasesFor("SJIS_0213"));
    }

    public boolean contains(Charset charset) {
        return charset.name().equals("US-ASCII") || charset instanceof SJIS || charset instanceof SJIS_0213;
    }

    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    protected static class Decoder
    extends CharsetDecoder {
        protected static final char UNMAPPABLE = '\ufffd';
        private char[] cc = new char[2];
        private CharsetMapping.Entry comp = new CharsetMapping.Entry();

        protected Decoder(Charset charset) {
            super(charset, 0.5f, 1.0f);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult decodeArrayLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            int n;
            byte[] byArray = byteBuffer.array();
            int n2 = byteBuffer.arrayOffset() + byteBuffer.limit();
            char[] cArray = charBuffer.array();
            int n3 = charBuffer.arrayOffset() + charBuffer.position();
            int n4 = charBuffer.arrayOffset() + charBuffer.limit();
            try {
                int n5;
                for (n = byteBuffer.arrayOffset() + byteBuffer.position(); n < n2; n += n5) {
                    int n6 = byArray[n] & 0xFF;
                    char c = this.decodeSingle(n6);
                    n5 = 1;
                    int n7 = 1;
                    char[] cArray2 = null;
                    if (c == '\ufffd') {
                        if (n2 - n < 2) {
                            CoderResult coderResult = CoderResult.UNDERFLOW;
                            return coderResult;
                        }
                        int n8 = byArray[n + 1] & 0xFF;
                        c = this.decodeDouble(n6, n8);
                        ++n5;
                        if (c == '\ufffd') {
                            cArray2 = this.decodeDoubleEx(n6, n8);
                            if (cArray2 == null) {
                                if (this.decodeSingle(n8) == '\ufffd') {
                                    CoderResult coderResult = CoderResult.unmappableForLength(2);
                                    return coderResult;
                                }
                                CoderResult coderResult = CoderResult.unmappableForLength(1);
                                return coderResult;
                            }
                            ++n7;
                        }
                    }
                    if (n4 - n3 < n7) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    if (n7 == 2) {
                        cArray[n3++] = cArray2[0];
                        cArray[n3++] = cArray2[1];
                        continue;
                    }
                    cArray[n3++] = c;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                byteBuffer.position(n - byteBuffer.arrayOffset());
                charBuffer.position(n3 - charBuffer.arrayOffset());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult decodeBufferLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            int n = byteBuffer.position();
            try {
                Object object;
                while (byteBuffer.hasRemaining()) {
                    object = null;
                    int n2 = byteBuffer.get() & 0xFF;
                    char c = this.decodeSingle(n2);
                    int n3 = 1;
                    int n4 = 1;
                    if (c == '\ufffd') {
                        if (byteBuffer.remaining() < 1) {
                            CoderResult coderResult = CoderResult.UNDERFLOW;
                            return coderResult;
                        }
                        int n5 = byteBuffer.get() & 0xFF;
                        ++n3;
                        c = this.decodeDouble(n2, n5);
                        if (c == '\ufffd') {
                            object = this.decodeDoubleEx(n2, n5);
                            if (object == null) {
                                if (this.decodeSingle(n5) == '\ufffd') {
                                    CoderResult coderResult = CoderResult.unmappableForLength(2);
                                    return coderResult;
                                }
                                CoderResult coderResult = CoderResult.unmappableForLength(1);
                                return coderResult;
                            }
                            ++n4;
                        }
                    }
                    if (charBuffer.remaining() < n4) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    if (n4 == 2) {
                        charBuffer.put((char)object[0]);
                        charBuffer.put((char)object[1]);
                    } else {
                        charBuffer.put(c);
                    }
                    n += n3;
                }
                object = CoderResult.UNDERFLOW;
                return object;
            }
            finally {
                byteBuffer.position(n);
            }
        }

        protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            if (byteBuffer.hasArray() && charBuffer.hasArray()) {
                return this.decodeArrayLoop(byteBuffer, charBuffer);
            }
            return this.decodeBufferLoop(byteBuffer, charBuffer);
        }

        protected char decodeSingle(int n) {
            return mapping.decodeSingle(n);
        }

        protected char decodeDouble(int n, int n2) {
            return mapping.decodeDouble(n, n2);
        }

        protected char[] decodeDoubleEx(int n, int n2) {
            int n3 = n << 8 | n2;
            if (mapping.decodeSurrogate(n3, this.cc) != null) {
                return this.cc;
            }
            this.comp.bs = n3;
            if (mapping.decodeComposite(this.comp, this.cc) != null) {
                return this.cc;
            }
            return null;
        }
    }

    protected static class Encoder
    extends CharsetEncoder {
        protected static final int UNMAPPABLE = 65533;
        protected static final int MAX_SINGLEBYTE = 255;
        private CharsetMapping.Entry comp = new CharsetMapping.Entry();
        char leftoverBase = '\u0000';

        protected Encoder(Charset charset) {
            super(charset, 2.0f, 2.0f);
        }

        public boolean canEncode(char c) {
            return this.encodeChar(c) != 65533;
        }

        protected int encodeChar(char c) {
            return mapping.encodeChar(c);
        }

        protected int encodeSurrogate(char c, char c2) {
            return mapping.encodeSurrogate(c, c2);
        }

        protected int encodeComposite(char c, char c2) {
            this.comp.cp = c;
            this.comp.cp2 = c2;
            return mapping.encodeComposite(this.comp);
        }

        protected boolean isCompositeBase(char c) {
            this.comp.cp = c;
            return mapping.isCompositeBase(this.comp);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected CoderResult encodeArrayLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            char[] cArray = charBuffer.array();
            int n = charBuffer.arrayOffset() + charBuffer.position();
            int n2 = charBuffer.arrayOffset() + charBuffer.limit();
            byte[] byArray = byteBuffer.array();
            int n3 = byteBuffer.arrayOffset() + byteBuffer.position();
            int n4 = byteBuffer.arrayOffset() + byteBuffer.limit();
            try {
                while (n < n2) {
                    int n5;
                    char c;
                    char c2 = cArray[n];
                    if (this.leftoverBase != '\u0000') {
                        c = '\u0000';
                        n5 = this.encodeComposite(this.leftoverBase, c2);
                        if (n5 == 65533) {
                            n5 = this.encodeChar(this.leftoverBase);
                        } else {
                            c = '\u0001';
                        }
                        if (n4 - n3 < 2) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        byArray[n3++] = (byte)(n5 >> 8);
                        byArray[n3++] = (byte)n5;
                        this.leftoverBase = '\u0000';
                        if (c != '\u0000') {
                            ++n;
                            continue;
                        }
                    }
                    if (this.isCompositeBase(c2)) {
                        this.leftoverBase = c2;
                    } else {
                        n5 = this.encodeChar(c2);
                        if (n5 <= 255) {
                            if (n4 <= n3) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            byArray[n3++] = (byte)n5;
                        } else if (n5 != 65533) {
                            if (n4 - n3 < 2) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            byArray[n3++] = (byte)(n5 >> 8);
                            byArray[n3++] = (byte)n5;
                        } else if (Character.isHighSurrogate(c2)) {
                            if (n + 1 == n2) {
                                CoderResult coderResult = CoderResult.UNDERFLOW;
                                return coderResult;
                            }
                            c = cArray[n + 1];
                            if (!Character.isLowSurrogate(c)) {
                                CoderResult coderResult = CoderResult.malformedForLength(1);
                                return coderResult;
                            }
                            n5 = this.encodeSurrogate(c2, c);
                            if (n5 == 65533) {
                                CoderResult coderResult = CoderResult.unmappableForLength(2);
                                return coderResult;
                            }
                            if (n4 - n3 < 2) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            byArray[n3++] = (byte)(n5 >> 8);
                            byArray[n3++] = (byte)n5;
                            ++n;
                        } else {
                            if (Character.isLowSurrogate(c2)) {
                                CoderResult coderResult = CoderResult.malformedForLength(1);
                                return coderResult;
                            }
                            CoderResult coderResult = CoderResult.unmappableForLength(1);
                            return coderResult;
                        }
                    }
                    ++n;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                charBuffer.position(n - charBuffer.arrayOffset());
                byteBuffer.position(n3 - byteBuffer.arrayOffset());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected CoderResult encodeBufferLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            int n = charBuffer.position();
            try {
                while (charBuffer.hasRemaining()) {
                    int n2;
                    char c;
                    char c2 = charBuffer.get();
                    if (this.leftoverBase != '\u0000') {
                        c = '\u0000';
                        n2 = this.encodeComposite(this.leftoverBase, c2);
                        if (n2 == 65533) {
                            n2 = this.encodeChar(this.leftoverBase);
                        } else {
                            c = '\u0001';
                        }
                        if (byteBuffer.remaining() < 2) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        byteBuffer.put((byte)(n2 >> 8));
                        byteBuffer.put((byte)n2);
                        this.leftoverBase = '\u0000';
                        if (c != '\u0000') {
                            ++n;
                            continue;
                        }
                    }
                    if (this.isCompositeBase(c2)) {
                        this.leftoverBase = c2;
                    } else {
                        n2 = this.encodeChar(c2);
                        if (n2 <= 255) {
                            if (byteBuffer.remaining() < 1) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            byteBuffer.put((byte)n2);
                        } else if (n2 != 65533) {
                            if (byteBuffer.remaining() < 2) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            byteBuffer.put((byte)(n2 >> 8));
                            byteBuffer.put((byte)n2);
                        } else if (Character.isHighSurrogate(c2)) {
                            if (!charBuffer.hasRemaining()) {
                                CoderResult coderResult = CoderResult.UNDERFLOW;
                                return coderResult;
                            }
                            c = charBuffer.get();
                            if (!Character.isLowSurrogate(c)) {
                                CoderResult coderResult = CoderResult.malformedForLength(1);
                                return coderResult;
                            }
                            n2 = this.encodeSurrogate(c2, c);
                            if (n2 == 65533) {
                                CoderResult coderResult = CoderResult.unmappableForLength(2);
                                return coderResult;
                            }
                            if (byteBuffer.remaining() < 2) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            byteBuffer.put((byte)(n2 >> 8));
                            byteBuffer.put((byte)n2);
                            ++n;
                        } else {
                            if (Character.isLowSurrogate(c2)) {
                                CoderResult coderResult = CoderResult.malformedForLength(1);
                                return coderResult;
                            }
                            CoderResult coderResult = CoderResult.unmappableForLength(1);
                            return coderResult;
                        }
                    }
                    ++n;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                charBuffer.position(n);
            }
        }

        protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            if (charBuffer.hasArray() && byteBuffer.hasArray()) {
                return this.encodeArrayLoop(charBuffer, byteBuffer);
            }
            return this.encodeBufferLoop(charBuffer, byteBuffer);
        }

        protected CoderResult implFlush(ByteBuffer byteBuffer) {
            if (this.leftoverBase > '\u0000') {
                if (byteBuffer.remaining() < 2) {
                    return CoderResult.OVERFLOW;
                }
                int n = this.encodeChar(this.leftoverBase);
                byteBuffer.put((byte)(n >> 8));
                byteBuffer.put((byte)n);
                this.leftoverBase = '\u0000';
            }
            return CoderResult.UNDERFLOW;
        }

        protected void implReset() {
            this.leftoverBase = '\u0000';
        }
    }
}

