/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.motif;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTabbedPaneUI;

public class MotifTabbedPaneUI
extends BasicTabbedPaneUI {
    protected Color unselectedTabBackground;
    protected Color unselectedTabForeground;
    protected Color unselectedTabShadow;
    protected Color unselectedTabHighlight;

    public static ComponentUI createUI(JComponent jComponent) {
        return new MotifTabbedPaneUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        this.unselectedTabBackground = UIManager.getColor("TabbedPane.unselectedTabBackground");
        this.unselectedTabForeground = UIManager.getColor("TabbedPane.unselectedTabForeground");
        this.unselectedTabShadow = UIManager.getColor("TabbedPane.unselectedTabShadow");
        this.unselectedTabHighlight = UIManager.getColor("TabbedPane.unselectedTabHighlight");
    }

    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.unselectedTabBackground = null;
        this.unselectedTabForeground = null;
        this.unselectedTabShadow = null;
        this.unselectedTabHighlight = null;
    }

    protected void paintContentBorderTopEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        Rectangle rectangle = n2 < 0 ? null : this.getTabBounds(n2, this.calcRect);
        graphics.setColor(this.lightHighlight);
        if (n != 1 || n2 < 0 || rectangle.x < n3 || rectangle.x > n3 + n5) {
            graphics.drawLine(n3, n4, n3 + n5 - 2, n4);
        } else {
            graphics.drawLine(n3, n4, rectangle.x - 1, n4);
            if (rectangle.x + rectangle.width < n3 + n5 - 2) {
                graphics.drawLine(rectangle.x + rectangle.width, n4, n3 + n5 - 2, n4);
            }
        }
    }

    protected void paintContentBorderBottomEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        Rectangle rectangle = n2 < 0 ? null : this.getTabBounds(n2, this.calcRect);
        graphics.setColor(this.shadow);
        if (n != 3 || n2 < 0 || rectangle.x < n3 || rectangle.x > n3 + n5) {
            graphics.drawLine(n3 + 1, n4 + n6 - 1, n3 + n5 - 1, n4 + n6 - 1);
        } else {
            graphics.drawLine(n3 + 1, n4 + n6 - 1, rectangle.x - 1, n4 + n6 - 1);
            if (rectangle.x + rectangle.width < n3 + n5 - 2) {
                graphics.drawLine(rectangle.x + rectangle.width, n4 + n6 - 1, n3 + n5 - 2, n4 + n6 - 1);
            }
        }
    }

    protected void paintContentBorderRightEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        Rectangle rectangle = n2 < 0 ? null : this.getTabBounds(n2, this.calcRect);
        graphics.setColor(this.shadow);
        if (n != 4 || n2 < 0 || rectangle.y < n4 || rectangle.y > n4 + n6) {
            graphics.drawLine(n3 + n5 - 1, n4 + 1, n3 + n5 - 1, n4 + n6 - 1);
        } else {
            graphics.drawLine(n3 + n5 - 1, n4 + 1, n3 + n5 - 1, rectangle.y - 1);
            if (rectangle.y + rectangle.height < n4 + n6 - 2) {
                graphics.drawLine(n3 + n5 - 1, rectangle.y + rectangle.height, n3 + n5 - 1, n4 + n6 - 2);
            }
        }
    }

    protected void paintTabBackground(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        graphics.setColor(bl ? this.tabPane.getBackgroundAt(n2) : this.unselectedTabBackground);
        switch (n) {
            case 2: {
                graphics.fillRect(n3 + 1, n4 + 1, n5 - 1, n6 - 2);
                break;
            }
            case 4: {
                graphics.fillRect(n3, n4 + 1, n5 - 1, n6 - 2);
                break;
            }
            case 3: {
                graphics.fillRect(n3 + 1, n4, n5 - 2, n6 - 3);
                graphics.drawLine(n3 + 2, n4 + n6 - 3, n3 + n5 - 3, n4 + n6 - 3);
                graphics.drawLine(n3 + 3, n4 + n6 - 2, n3 + n5 - 4, n4 + n6 - 2);
                break;
            }
            default: {
                graphics.fillRect(n3 + 1, n4 + 3, n5 - 2, n6 - 3);
                graphics.drawLine(n3 + 2, n4 + 2, n3 + n5 - 3, n4 + 2);
                graphics.drawLine(n3 + 3, n4 + 1, n3 + n5 - 4, n4 + 1);
            }
        }
    }

    protected void paintTabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        graphics.setColor(bl ? this.lightHighlight : this.unselectedTabHighlight);
        switch (n) {
            case 2: {
                graphics.drawLine(n3, n4 + 2, n3, n4 + n6 - 3);
                graphics.drawLine(n3 + 1, n4 + 1, n3 + 1, n4 + 2);
                graphics.drawLine(n3 + 2, n4, n3 + 2, n4 + 1);
                graphics.drawLine(n3 + 3, n4, n3 + n5 - 1, n4);
                graphics.setColor(bl ? this.shadow : this.unselectedTabShadow);
                graphics.drawLine(n3 + 1, n4 + n6 - 3, n3 + 1, n4 + n6 - 2);
                graphics.drawLine(n3 + 2, n4 + n6 - 2, n3 + 2, n4 + n6 - 1);
                graphics.drawLine(n3 + 3, n4 + n6 - 1, n3 + n5 - 1, n4 + n6 - 1);
                break;
            }
            case 4: {
                graphics.drawLine(n3, n4, n3 + n5 - 3, n4);
                graphics.setColor(bl ? this.shadow : this.unselectedTabShadow);
                graphics.drawLine(n3 + n5 - 3, n4, n3 + n5 - 3, n4 + 1);
                graphics.drawLine(n3 + n5 - 2, n4 + 1, n3 + n5 - 2, n4 + 2);
                graphics.drawLine(n3 + n5 - 1, n4 + 2, n3 + n5 - 1, n4 + n6 - 3);
                graphics.drawLine(n3 + n5 - 2, n4 + n6 - 3, n3 + n5 - 2, n4 + n6 - 2);
                graphics.drawLine(n3 + n5 - 3, n4 + n6 - 2, n3 + n5 - 3, n4 + n6 - 1);
                graphics.drawLine(n3, n4 + n6 - 1, n3 + n5 - 3, n4 + n6 - 1);
                break;
            }
            case 3: {
                graphics.drawLine(n3, n4, n3, n4 + n6 - 3);
                graphics.drawLine(n3 + 1, n4 + n6 - 3, n3 + 1, n4 + n6 - 2);
                graphics.drawLine(n3 + 2, n4 + n6 - 2, n3 + 2, n4 + n6 - 1);
                graphics.setColor(bl ? this.shadow : this.unselectedTabShadow);
                graphics.drawLine(n3 + 3, n4 + n6 - 1, n3 + n5 - 4, n4 + n6 - 1);
                graphics.drawLine(n3 + n5 - 3, n4 + n6 - 2, n3 + n5 - 3, n4 + n6 - 1);
                graphics.drawLine(n3 + n5 - 2, n4 + n6 - 3, n3 + n5 - 2, n4 + n6 - 2);
                graphics.drawLine(n3 + n5 - 1, n4, n3 + n5 - 1, n4 + n6 - 3);
                break;
            }
            default: {
                graphics.drawLine(n3, n4 + 2, n3, n4 + n6 - 1);
                graphics.drawLine(n3 + 1, n4 + 1, n3 + 1, n4 + 2);
                graphics.drawLine(n3 + 2, n4, n3 + 2, n4 + 1);
                graphics.drawLine(n3 + 3, n4, n3 + n5 - 4, n4);
                graphics.setColor(bl ? this.shadow : this.unselectedTabShadow);
                graphics.drawLine(n3 + n5 - 3, n4, n3 + n5 - 3, n4 + 1);
                graphics.drawLine(n3 + n5 - 2, n4 + 1, n3 + n5 - 2, n4 + 2);
                graphics.drawLine(n3 + n5 - 1, n4 + 2, n3 + n5 - 1, n4 + n6 - 1);
            }
        }
    }

    protected void paintFocusIndicator(Graphics graphics, int n, Rectangle[] rectangleArray, int n2, Rectangle rectangle, Rectangle rectangle2, boolean bl) {
        Rectangle rectangle3 = rectangleArray[n2];
        if (this.tabPane.hasFocus() && bl) {
            int n3;
            int n4;
            int n5;
            int n6;
            graphics.setColor(this.focus);
            switch (n) {
                case 2: {
                    n6 = rectangle3.x + 3;
                    n5 = rectangle3.y + 3;
                    n4 = rectangle3.width - 6;
                    n3 = rectangle3.height - 7;
                    break;
                }
                case 4: {
                    n6 = rectangle3.x + 2;
                    n5 = rectangle3.y + 3;
                    n4 = rectangle3.width - 6;
                    n3 = rectangle3.height - 7;
                    break;
                }
                case 3: {
                    n6 = rectangle3.x + 3;
                    n5 = rectangle3.y + 2;
                    n4 = rectangle3.width - 7;
                    n3 = rectangle3.height - 6;
                    break;
                }
                default: {
                    n6 = rectangle3.x + 3;
                    n5 = rectangle3.y + 3;
                    n4 = rectangle3.width - 7;
                    n3 = rectangle3.height - 6;
                }
            }
            graphics.drawRect(n6, n5, n4, n3);
        }
    }

    protected int getTabRunIndent(int n, int n2) {
        return n2 * 3;
    }

    protected int getTabRunOverlay(int n) {
        this.tabRunOverlay = n == 2 || n == 4 ? (int)Math.round((double)this.maxTabWidth * 0.1) : (int)Math.round((double)this.maxTabHeight * 0.22);
        switch (n) {
            case 2: {
                if (this.tabRunOverlay <= this.tabInsets.right - 2) break;
                this.tabRunOverlay = this.tabInsets.right - 2;
                break;
            }
            case 4: {
                if (this.tabRunOverlay <= this.tabInsets.left - 2) break;
                this.tabRunOverlay = this.tabInsets.left - 2;
                break;
            }
            case 1: {
                if (this.tabRunOverlay <= this.tabInsets.bottom - 2) break;
                this.tabRunOverlay = this.tabInsets.bottom - 2;
                break;
            }
            case 3: {
                if (this.tabRunOverlay <= this.tabInsets.top - 2) break;
                this.tabRunOverlay = this.tabInsets.top - 2;
            }
        }
        return this.tabRunOverlay;
    }
}

