/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.Map;
import sun.font.Font2D;
import sun.font.FontManager;
import sun.text.CodePointIterator;

public final class FontResolver {
    private Font[] allFonts;
    private Font[] supplementaryFonts;
    private int[] supplementaryIndices;
    private static final int DEFAULT_SIZE = 12;
    private Font defaultFont = new Font("Dialog", 0, 12);
    private static final int SHIFT = 9;
    private static final int BLOCKSIZE = 128;
    private static final int MASK = 127;
    private int[][] blocks = new int[512][];
    private static FontResolver INSTANCE;

    private FontResolver() {
    }

    private Font[] getAllFonts() {
        if (this.allFonts == null) {
            this.allFonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
            for (int i = 0; i < this.allFonts.length; ++i) {
                this.allFonts[i] = this.allFonts[i].deriveFont(12.0f);
            }
        }
        return this.allFonts;
    }

    private int getIndexFor(char c) {
        if (this.defaultFont.canDisplay(c)) {
            return 1;
        }
        for (int i = 0; i < this.getAllFonts().length; ++i) {
            if (!this.allFonts[i].canDisplay(c)) continue;
            return i + 2;
        }
        return 1;
    }

    private Font[] getAllSCFonts() {
        if (this.supplementaryFonts == null) {
            int n;
            ArrayList<Font> arrayList = new ArrayList<Font>();
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            for (n = 0; n < this.getAllFonts().length; ++n) {
                Font font = this.allFonts[n];
                Font2D font2D = FontManager.getFont2D(font);
                if (!font2D.hasSupplementaryChars()) continue;
                arrayList.add(font);
                arrayList2.add(new Integer(n));
            }
            n = arrayList.size();
            this.supplementaryIndices = new int[n];
            for (int i = 0; i < n; ++i) {
                this.supplementaryIndices[i] = (Integer)arrayList2.get(i);
            }
            this.supplementaryFonts = arrayList.toArray(new Font[n]);
        }
        return this.supplementaryFonts;
    }

    private int getIndexFor(int n) {
        if (this.defaultFont.canDisplay(n)) {
            return 1;
        }
        for (int i = 0; i < this.getAllSCFonts().length; ++i) {
            if (!this.supplementaryFonts[i].canDisplay(n)) continue;
            return this.supplementaryIndices[i] + 2;
        }
        return 1;
    }

    public int getFontIndex(char c) {
        int n;
        int n2 = c >> 9;
        int[] nArray = this.blocks[n2];
        if (nArray == null) {
            nArray = new int[128];
            this.blocks[n2] = nArray;
        }
        if (nArray[n = c & 0x7F] == 0) {
            nArray[n] = this.getIndexFor(c);
        }
        return nArray[n];
    }

    public int getFontIndex(int n) {
        if (n < 65536) {
            return this.getFontIndex((char)n);
        }
        return this.getIndexFor(n);
    }

    public int nextFontRunIndex(CodePointIterator codePointIterator) {
        int n = codePointIterator.next();
        int n2 = 1;
        if (n != -1) {
            n2 = this.getFontIndex(n);
            while ((n = codePointIterator.next()) != -1) {
                if (this.getFontIndex(n) == n2) continue;
                codePointIterator.prev();
                break;
            }
        }
        return n2;
    }

    public Font getFont(int n, Map map) {
        Font font = this.defaultFont;
        if (n >= 2) {
            font = this.allFonts[n - 2];
        }
        return font.deriveFont(map);
    }

    public static FontResolver getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new FontResolver();
        }
        return INSTANCE;
    }
}

