/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.org.jvnet.mimepull;

import com.sun.xml.internal.org.jvnet.mimepull.Chunk;
import com.sun.xml.internal.org.jvnet.mimepull.Data;
import com.sun.xml.internal.org.jvnet.mimepull.DataFile;
import com.sun.xml.internal.org.jvnet.mimepull.DataHead;
import com.sun.xml.internal.org.jvnet.mimepull.FileData;
import com.sun.xml.internal.org.jvnet.mimepull.MIMEConfig;
import com.sun.xml.internal.org.jvnet.mimepull.MIMEParsingException;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.logging.Logger;

final class MemoryData
implements Data {
    private static final Logger LOGGER = Logger.getLogger(MemoryData.class.getName());
    private final byte[] data;
    private final int len;
    private final MIMEConfig config;

    MemoryData(ByteBuffer byteBuffer, MIMEConfig mIMEConfig) {
        this.data = byteBuffer.array();
        this.len = byteBuffer.limit();
        this.config = mIMEConfig;
    }

    public int size() {
        return this.len;
    }

    public byte[] read() {
        return this.data;
    }

    public long writeTo(DataFile dataFile) {
        return dataFile.writeTo(this.data, 0, this.len);
    }

    public Data createNext(DataHead dataHead, ByteBuffer byteBuffer) {
        if (!this.config.isOnlyMemory() && dataHead.inMemory >= this.config.memoryThreshold) {
            Object object;
            try {
                object = this.config.getTempFilePrefix();
                String string = this.config.getTempFileSuffix();
                File file = this.config.getTempDir();
                File file2 = file == null ? File.createTempFile((String)object, string) : File.createTempFile((String)object, string, file);
                LOGGER.fine("Created temp file = " + file2);
                dataHead.dataFile = new DataFile(file2);
            }
            catch (IOException iOException) {
                throw new MIMEParsingException(iOException);
            }
            if (dataHead.head != null) {
                object = dataHead.head;
                while (object != null) {
                    long l = ((Chunk)object).data.writeTo(dataHead.dataFile);
                    ((Chunk)object).data = new FileData(dataHead.dataFile, l, this.len);
                    object = ((Chunk)object).next;
                }
            }
            return new FileData(dataHead.dataFile, byteBuffer);
        }
        return new MemoryData(byteBuffer, this.config);
    }
}

