/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.JsseJce;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;

final class DHCrypt {
    private BigInteger modulus;
    private BigInteger base;
    private PrivateKey privateKey;
    private BigInteger publicValue;

    DHCrypt(int n, SecureRandom secureRandom) {
        try {
            KeyPairGenerator keyPairGenerator = JsseJce.getKeyPairGenerator("DiffieHellman");
            keyPairGenerator.initialize(n, secureRandom);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            this.privateKey = keyPair.getPrivate();
            DHPublicKeySpec dHPublicKeySpec = DHCrypt.getDHPublicKeySpec(keyPair.getPublic());
            this.publicValue = dHPublicKeySpec.getY();
            this.modulus = dHPublicKeySpec.getP();
            this.base = dHPublicKeySpec.getG();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new RuntimeException("Could not generate DH keypair", generalSecurityException);
        }
    }

    DHCrypt(BigInteger bigInteger, BigInteger bigInteger2, SecureRandom secureRandom) {
        this.modulus = bigInteger;
        this.base = bigInteger2;
        try {
            KeyPairGenerator keyPairGenerator = JsseJce.getKeyPairGenerator("DiffieHellman");
            DHParameterSpec dHParameterSpec = new DHParameterSpec(bigInteger, bigInteger2);
            keyPairGenerator.initialize(dHParameterSpec, secureRandom);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            this.privateKey = keyPair.getPrivate();
            DHPublicKeySpec dHPublicKeySpec = DHCrypt.getDHPublicKeySpec(keyPair.getPublic());
            this.publicValue = dHPublicKeySpec.getY();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new RuntimeException("Could not generate DH keypair", generalSecurityException);
        }
    }

    static DHPublicKeySpec getDHPublicKeySpec(PublicKey publicKey) {
        if (publicKey instanceof DHPublicKey) {
            DHPublicKey dHPublicKey = (DHPublicKey)publicKey;
            DHParameterSpec dHParameterSpec = dHPublicKey.getParams();
            return new DHPublicKeySpec(dHPublicKey.getY(), dHParameterSpec.getP(), dHParameterSpec.getG());
        }
        try {
            KeyFactory keyFactory = JsseJce.getKeyFactory("DH");
            return keyFactory.getKeySpec(publicKey, DHPublicKeySpec.class);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    BigInteger getModulus() {
        return this.modulus;
    }

    BigInteger getBase() {
        return this.base;
    }

    BigInteger getPublicKey() {
        return this.publicValue;
    }

    SecretKey getAgreedSecret(BigInteger bigInteger) {
        try {
            KeyFactory keyFactory = JsseJce.getKeyFactory("DiffieHellman");
            DHPublicKeySpec dHPublicKeySpec = new DHPublicKeySpec(bigInteger, this.modulus, this.base);
            PublicKey publicKey = keyFactory.generatePublic(dHPublicKeySpec);
            KeyAgreement keyAgreement = JsseJce.getKeyAgreement("DiffieHellman");
            keyAgreement.init(this.privateKey);
            keyAgreement.doPhase(publicKey, true);
            return keyAgreement.generateSecret("TlsPremasterSecret");
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new RuntimeException("Could not generate secret", generalSecurityException);
        }
    }
}

