/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.setup.Util;

import java.util.Enumeration;
import org.openoffice.setup.InstallData;
import org.openoffice.setup.SetupData.PackageDescription;
import org.openoffice.setup.SetupData.ProductDescription;
import org.openoffice.setup.Util.LogManager;

public class InfoCtrl {
    private InfoCtrl() {
    }

    public static String setHtmlFrame(String position, String htmlInfoText) {
        if (position.equals("header")) {
            htmlInfoText = "<HTML><BODY><FONT FACE=\"sans-serif\" SIZE=3>";
        } else if (position.equals("end")) {
            htmlInfoText = htmlInfoText + "</FONT></BODY></HTML>";
        }
        return htmlInfoText;
    }

    public static String setReadyToInstallInfoText(ProductDescription productData, String htmlInfoText) {
        String oneline = "-------------------------------------------------------------";
        htmlInfoText = htmlInfoText + "<b>Product</b>: " + productData.get("product_fullname") + "<br>";
        InstallData data = InstallData.getInstance();
        htmlInfoText = htmlInfoText + "<b>Location</b>: " + data.getInstallDefaultDir() + "<br>";
        htmlInfoText = htmlInfoText + oneline + "<br>";
        return htmlInfoText;
    }

    public static String setReadyToInstallInfoText(PackageDescription packageData, String htmlInfoText) {
        InstallData data = InstallData.getInstance();
        htmlInfoText = data.isInstallationMode() ? InfoCtrl.setReadyToInstallInfoText(packageData, "", htmlInfoText) : InfoCtrl.setReadyToUninstallInfoText(packageData, "", htmlInfoText);
        return htmlInfoText;
    }

    private static String setReadyToInstallInfoText(PackageDescription packageData, String indent, String htmlInfoText) {
        block6: {
            block7: {
                block8: {
                    if ((packageData.isLeaf() || packageData.isAllChildrenHidden()) && !packageData.isHidden()) {
                        if (packageData.getSelectionState() == 1) {
                            htmlInfoText = htmlInfoText + indent + packageData.getName() + "<br>";
                        }
                    }
                    if (packageData.isLeaf() || packageData.isAllChildrenHidden()) break block6;
                    if (packageData.isHidden()) break block7;
                    if (packageData.getSelectionState() == 1) break block8;
                    if (packageData.getSelectionState() != 2) break block7;
                }
                htmlInfoText = htmlInfoText + indent + packageData.getName() + "<br>";
            }
            indent = indent + "..";
            Enumeration e = packageData.children();
            while (e.hasMoreElements()) {
                PackageDescription child = (PackageDescription)e.nextElement();
                htmlInfoText = InfoCtrl.setReadyToInstallInfoText(child, indent, htmlInfoText);
            }
        }
        return htmlInfoText;
    }

    private static String setReadyToUninstallInfoText(PackageDescription packageData, String indent, String htmlInfoText) {
        block6: {
            block7: {
                block8: {
                    if ((packageData.isLeaf() || packageData.isAllChildrenHidden()) && !packageData.isHidden()) {
                        if (packageData.getSelectionState() == 3) {
                            htmlInfoText = htmlInfoText + indent + packageData.getName() + "<br>";
                        }
                    }
                    if (packageData.isLeaf() || packageData.isAllChildrenHidden()) break block6;
                    if (packageData.isHidden()) break block7;
                    if (packageData.getSelectionState() == 3) break block8;
                    if (packageData.getSelectionState() != 5) break block7;
                }
                htmlInfoText = htmlInfoText + indent + packageData.getName() + "<br>";
            }
            indent = indent + "..";
            Enumeration e = packageData.children();
            while (e.hasMoreElements()) {
                PackageDescription child = (PackageDescription)e.nextElement();
                htmlInfoText = InfoCtrl.setReadyToUninstallInfoText(child, indent, htmlInfoText);
            }
        }
        return htmlInfoText;
    }

    public static String setInstallLogInfoText(ProductDescription productData, String htmlInfoText) {
        String separatorline = "-------------------------------------------------------------";
        htmlInfoText = htmlInfoText + "<b>Product</b>: " + productData.get("product_fullname") + "<br>";
        InstallData data = InstallData.getInstance();
        htmlInfoText = htmlInfoText + "<b>Location</b>: " + data.getInstallDir() + "<br>";
        htmlInfoText = htmlInfoText + "<b>Operating system</b>: " + data.getOSType() + "<br>";
        htmlInfoText = data.isUserInstallation() ? htmlInfoText + "<b>Installation type</b>: " + "User installation" + "<br>" : htmlInfoText + "<b>Installation type</b>: " + "Root installation" + "<br>";
        htmlInfoText = htmlInfoText + separatorline + "<br>";
        htmlInfoText = LogManager.publishLogfileContent(htmlInfoText, separatorline);
        htmlInfoText = LogManager.publishCommandsLogfileContent(htmlInfoText);
        return htmlInfoText;
    }
}

