/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.message.stream;

import com.sun.istack.internal.FinalArrayList;
import com.sun.istack.internal.NotNull;
import com.sun.xml.internal.stream.buffer.XMLStreamBuffer;
import com.sun.xml.internal.stream.buffer.XMLStreamBufferException;
import com.sun.xml.internal.ws.message.AbstractHeaderImpl;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.ws.WebServiceException;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public final class OutboundStreamHeader
extends AbstractHeaderImpl {
    private final XMLStreamBuffer infoset;
    private final String nsUri;
    private final String localName;
    private FinalArrayList<Attribute> attributes;
    private static final String TRUE_VALUE = "1";
    private static final String IS_REFERENCE_PARAMETER = "IsReferenceParameter";

    public OutboundStreamHeader(XMLStreamBuffer xMLStreamBuffer, String string, String string2) {
        this.infoset = xMLStreamBuffer;
        this.nsUri = string;
        this.localName = string2;
    }

    @NotNull
    public String getNamespaceURI() {
        return this.nsUri;
    }

    @NotNull
    public String getLocalPart() {
        return this.localName;
    }

    public String getAttribute(String string, String string2) {
        if (this.attributes == null) {
            this.parseAttributes();
        }
        for (int i = this.attributes.size() - 1; i >= 0; --i) {
            Attribute attribute = (Attribute)this.attributes.get(i);
            if (!attribute.localName.equals(string2) || !attribute.nsUri.equals(string)) continue;
            return attribute.value;
        }
        return null;
    }

    private void parseAttributes() {
        try {
            XMLStreamReader xMLStreamReader = this.readHeader();
            this.attributes = new FinalArrayList();
            for (int i = 0; i < xMLStreamReader.getAttributeCount(); ++i) {
                String string = xMLStreamReader.getAttributeLocalName(i);
                String string2 = xMLStreamReader.getAttributeNamespace(i);
                String string3 = xMLStreamReader.getAttributeValue(i);
                this.attributes.add(new Attribute(string2, string, string3));
            }
        }
        catch (XMLStreamException xMLStreamException) {
            throw new WebServiceException("Unable to read the attributes for {" + this.nsUri + "}" + this.localName + " header", xMLStreamException);
        }
    }

    public XMLStreamReader readHeader() throws XMLStreamException {
        return this.infoset.readAsXMLStreamReader();
    }

    public void writeTo(XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        this.infoset.writeToXMLStreamWriter(xMLStreamWriter, true);
    }

    public void writeTo(SOAPMessage sOAPMessage) throws SOAPException {
        try {
            this.infoset.writeTo(sOAPMessage.getSOAPHeader());
        }
        catch (XMLStreamBufferException xMLStreamBufferException) {
            throw new SOAPException(xMLStreamBufferException);
        }
    }

    public void writeTo(ContentHandler contentHandler, ErrorHandler errorHandler) throws SAXException {
        this.infoset.writeTo(contentHandler, errorHandler);
    }

    static final class Attribute {
        final String nsUri;
        final String localName;
        final String value;

        public Attribute(String string, String string2, String string3) {
            this.nsUri = Attribute.fixNull(string);
            this.localName = string2;
            this.value = string3;
        }

        private static String fixNull(String string) {
            if (string == null) {
                return "";
            }
            return string;
        }
    }
}

