/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.ReflectPermission;
import java.security.AccessController;
import java.security.Permission;
import sun.reflect.ReflectionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessibleObject
implements AnnotatedElement {
    private static final Permission ACCESS_PERMISSION = new ReflectPermission("suppressAccessChecks");
    boolean override;
    static final ReflectionFactory reflectionFactory = (ReflectionFactory)AccessController.doPrivileged(new ReflectionFactory.GetReflectionFactoryAction());

    public static void setAccessible(AccessibleObject[] accessibleObjectArray, boolean bl) throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(ACCESS_PERMISSION);
        }
        for (int i = 0; i < accessibleObjectArray.length; ++i) {
            AccessibleObject.setAccessible0(accessibleObjectArray[i], bl);
        }
    }

    public void setAccessible(boolean bl) throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(ACCESS_PERMISSION);
        }
        AccessibleObject.setAccessible0(this, bl);
    }

    private static void setAccessible0(AccessibleObject accessibleObject, boolean bl) throws SecurityException {
        Constructor constructor;
        if (accessibleObject instanceof Constructor && bl && (constructor = (Constructor)accessibleObject).getDeclaringClass() == Class.class) {
            throw new SecurityException("Can not make a java.lang.Class constructor accessible");
        }
        accessibleObject.override = bl;
    }

    public boolean isAccessible() {
        return this.override;
    }

    protected AccessibleObject() {
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> clazz) {
        throw new AssertionError((Object)"All subclasses should override this method");
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> clazz) {
        return this.getAnnotation(clazz) != null;
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.getDeclaredAnnotations();
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        throw new AssertionError((Object)"All subclasses should override this method");
    }
}

