/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.ImageConsumer;
import java.awt.image.ImageFilter;
import java.awt.image.ImageProducer;
import java.util.Hashtable;

public class FilteredImageSource
implements ImageProducer {
    ImageProducer src;
    ImageFilter filter;
    private Hashtable proxies;

    public FilteredImageSource(ImageProducer imageProducer, ImageFilter imageFilter) {
        this.src = imageProducer;
        this.filter = imageFilter;
    }

    public synchronized void addConsumer(ImageConsumer imageConsumer) {
        if (this.proxies == null) {
            this.proxies = new Hashtable();
        }
        if (!this.proxies.containsKey(imageConsumer)) {
            ImageFilter imageFilter = this.filter.getFilterInstance(imageConsumer);
            this.proxies.put(imageConsumer, imageFilter);
            this.src.addConsumer(imageFilter);
        }
    }

    public synchronized boolean isConsumer(ImageConsumer imageConsumer) {
        return this.proxies != null && this.proxies.containsKey(imageConsumer);
    }

    public synchronized void removeConsumer(ImageConsumer imageConsumer) {
        ImageFilter imageFilter;
        if (this.proxies != null && (imageFilter = (ImageFilter)this.proxies.get(imageConsumer)) != null) {
            this.src.removeConsumer(imageFilter);
            this.proxies.remove(imageConsumer);
            if (this.proxies.isEmpty()) {
                this.proxies = null;
            }
        }
    }

    public void startProduction(ImageConsumer imageConsumer) {
        ImageFilter imageFilter;
        if (this.proxies == null) {
            this.proxies = new Hashtable();
        }
        if ((imageFilter = (ImageFilter)this.proxies.get(imageConsumer)) == null) {
            imageFilter = this.filter.getFilterInstance(imageConsumer);
            this.proxies.put(imageConsumer, imageFilter);
        }
        this.src.startProduction(imageFilter);
    }

    public void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
        ImageFilter imageFilter;
        if (this.proxies != null && (imageFilter = (ImageFilter)this.proxies.get(imageConsumer)) != null) {
            imageFilter.resendTopDownLeftRight(this.src);
        }
    }
}

