/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;

public abstract class SingleByteDecoder
extends CharsetDecoder {
    private final char[] byteToCharTable;

    protected SingleByteDecoder(Charset charset, String string) {
        super(charset, 1.0f, 1.0f);
        this.byteToCharTable = string.toCharArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult decodeArrayLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        byte[] byArray = byteBuffer.array();
        int n = byteBuffer.arrayOffset() + byteBuffer.position();
        int n2 = byteBuffer.arrayOffset() + byteBuffer.limit();
        assert (n <= n2);
        char[] cArray = charBuffer.array();
        int n3 = charBuffer.arrayOffset() + charBuffer.position();
        int n4 = charBuffer.arrayOffset() + charBuffer.limit();
        assert (n3 <= n4);
        n3 = n3 <= n4 ? n3 : n4;
        try {
            for (n = n <= n2 ? n : n2; n < n2; ++n) {
                byte by = byArray[n];
                char c = this.decode(by);
                if (c == '\ufffd') {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                if (n4 - n3 < 1) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                cArray[n3++] = c;
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            byteBuffer.position(n - byteBuffer.arrayOffset());
            charBuffer.position(n3 - charBuffer.arrayOffset());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult decodeBufferLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        int n = byteBuffer.position();
        try {
            while (byteBuffer.hasRemaining()) {
                byte by = byteBuffer.get();
                char c = this.decode(by);
                if (c == '\ufffd') {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                if (!charBuffer.hasRemaining()) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                ++n;
                charBuffer.put(c);
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            byteBuffer.position(n);
        }
    }

    protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        if (byteBuffer.hasArray() && charBuffer.hasArray()) {
            return this.decodeArrayLoop(byteBuffer, charBuffer);
        }
        return this.decodeBufferLoop(byteBuffer, charBuffer);
    }

    public char decode(int n) {
        int n2 = n + 128;
        if (n2 >= this.byteToCharTable.length || n2 < 0) {
            return '\ufffd';
        }
        return this.byteToCharTable[n2];
    }
}

