/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.platform.mckoi;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import org.apache.ddlutils.DatabaseOperationException;
import org.apache.ddlutils.PlatformInfo;
import org.apache.ddlutils.platform.PlatformImplBase;
import org.apache.ddlutils.platform.mckoi.MckoiBuilder;
import org.apache.ddlutils.platform.mckoi.MckoiModelReader;

public class MckoiPlatform
extends PlatformImplBase {
    public static final String DATABASENAME = "McKoi";
    public static final String JDBC_DRIVER = "com.mckoi.JDBCDriver";
    public static final String JDBC_SUBPROTOCOL = "mckoi";

    public MckoiPlatform() {
        PlatformInfo info = this.getPlatformInfo();
        info.setIndicesSupported(false);
        info.setIndicesEmbedded(true);
        info.setDefaultValueUsedForIdentitySpec(true);
        info.setAutoCommitModeForLastIdentityValueReading(false);
        info.addNativeTypeMapping(2003, "BLOB", 2004);
        info.addNativeTypeMapping(2001, "BLOB", 2004);
        info.addNativeTypeMapping(6, "DOUBLE", 8);
        info.addNativeTypeMapping(0, "BLOB", 2004);
        info.addNativeTypeMapping(1111, "BLOB", 2004);
        info.addNativeTypeMapping(2006, "BLOB", 2004);
        info.addNativeTypeMapping(2002, "BLOB", 2004);
        info.addNativeTypeMapping("BIT", "BOOLEAN", "BOOLEAN");
        info.addNativeTypeMapping("DATALINK", "BLOB", "BLOB");
        info.setDefaultSize(1, 1024);
        info.setDefaultSize(12, 1024);
        info.setDefaultSize(-2, 1024);
        info.setDefaultSize(-3, 1024);
        this.setSqlBuilder(new MckoiBuilder(this));
        this.setModelReader(new MckoiModelReader(this));
    }

    public String getName() {
        return DATABASENAME;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createDatabase(String jdbcDriverClassName, String connectionUrl, String username, String password, Map parameters) throws DatabaseOperationException, UnsupportedOperationException {
        if (!JDBC_DRIVER.equals(jdbcDriverClassName)) throw new UnsupportedOperationException("Unable to create a Derby database via the driver " + jdbcDriverClassName);
        StringBuffer creationUrl = new StringBuffer();
        Connection connection = null;
        creationUrl.append(connectionUrl);
        creationUrl.append("?create=true");
        if (parameters != null && !parameters.isEmpty()) {
            Iterator it = parameters.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                if ("create".equalsIgnoreCase(entry.getKey().toString())) continue;
                creationUrl.append("&");
                creationUrl.append(entry.getKey().toString());
                creationUrl.append("=");
                if (entry.getValue() == null) continue;
                creationUrl.append(entry.getValue().toString());
            }
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((Object)("About to create database using this URL: " + creationUrl.toString()));
        }
        try {
            try {
                Class.forName(jdbcDriverClassName);
                connection = DriverManager.getConnection(creationUrl.toString(), username, password);
                this.logWarnings(connection);
            }
            catch (Exception ex) {
                throw new DatabaseOperationException("Error while trying to create a database", ex);
            }
            Object var11_11 = null;
            if (connection == null) return;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            if (connection == null) throw throwable;
            try {
                connection.close();
                throw throwable;
            }
            catch (SQLException ex) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (SQLException ex) {}
        connection.close();
        return;
    }
}

