/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BoxHolder;
import edu.harvard.hul.ois.jhove.module.jpeg2000.Codestream;
import edu.harvard.hul.ois.jhove.module.jpeg2000.ContCodestream;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Box;
import java.io.IOException;
import java.io.RandomAccessFile;

public class ContCodestreamBox
extends JP2Box {
    public ContCodestreamBox(RandomAccessFile randomAccessFile, BoxHolder boxHolder) {
        super(randomAccessFile, boxHolder);
    }

    @Override
    public boolean readBox() throws IOException {
        this.initBytesRead();
        if (!this._module.isJP2HdrSeen()) {
            this._repInfo.setMessage((Message)new ErrorMessage("Other boxes may not occur before JP2 Header", this._module.getFilePos()));
            return false;
        }
        int n = this._module.getNCodestreams() + 1;
        this._module.setNCodestreams(n);
        Codestream codestream = this._module.getCodestream(n);
        long l = this._boxHeader.getLength() == 0L ? 0L : this._boxHeader.getDataLength();
        ContCodestream contCodestream = new ContCodestream(this._module, this._dstrm, l);
        boolean bl = contCodestream.readCodestream(codestream, this._repInfo);
        this.finalizeBytesRead();
        return bl;
    }

    @Override
    protected String getSelfPropName() {
        return "Contiguous Codestream Box";
    }
}

