# Section B - Why do anarchists oppose the current system?

This section of the FAQ presents an analysis of the basic social relationships
of modern society and the structures which create them, particularly those
aspects of society that anarchists want to change.

Anarchism is, essentially, a revolt against capitalism. As a political theory
it was born at the same time as capitalism and in opposition to it. As a
social movement it grew in strength and influence as capitalism colonised more
and more parts of society. Rather than simply express opposition to the state,
as some so-called experts assert, anarchism has always been opposed to other
forms of authority and the oppression they create, in particular capitalism
and its particular form of private property. It is no coincidence that
Proudhon, the first person to declare themselves an anarchist, did so in a
book entitled **What is Property?** (and gave the answer _**"It is
theft!"**_). From Proudhon onwards, anarchism has opposed both the state and
capitalism (indeed, it is the one thing such diverse thinkers as Benjamin
Tucker and Peter Kropotkin both agreed on). Needless to say, since Proudhon
anarchism has extended its critique of authority beyond these two social
evils. Other forms of social hierarchy, such as sexism, racism and homophobia,
have been rejected as limitations of freedom and equality. So this section of
the FAQ summarises the key ideas behind anarchism's rejection of the current
system we live under.

This, of course, does not mean that anarchistic ideas have not existed within
society before the dawn of capitalism. Far from it. Thinkers whose ideas can
be classified as anarchist go back thousands of years and are found many
diverse cultures and places. Indeed, it would be no exaggeration to say that
anarchism was born the moment the state and private property were created.
However, as Kropotkin noted, while _"from all times there have been Anarchists
and Statists"_ in our times _"Anarchy was brought forth by the same critical
and revolutionary protest that gave rise to Socialism in general."_ However,
unlike other socialists, anarchists have not stopped at the _"negation of
Capitalism and of society based on the subjection of labour to capital"_ and
went further to _"declare themselves against what constitutes the real
strength of Capitalism: the State and its principle supports -- centralisation
of authority, law, always made by a minority for its own profit, and a form of
justice whose chief aim is to protect Authority and Capitalism."_ So anarchism
was _"not only against Capitalism, but also against these pillars of
Capitalism: Law, Authority, and the State."_ [**Evolution and Environment**,
p. 16 and p. 19]

In other words, anarchism as it exists today, as a social movement with a long
history of struggle and with a political theory and set of ideas, is the
product of the transformation of society which accompanied the creation of the
modern (nation-) state and capital and (far more importantly) the reaction,
resistance and opposition of those subject to these new social relationships
and institutions. As such, the analysis and critique presented in this section
of the FAQ will concentrate on modern, capitalist, society.

Anarchists realise that the power of governments and other forms of hierarchy
depends upon the agreement of the governed. Fear is not the whole answer, it
is far more _"because they [the oppressed] subscribe to the same values as
their governors. Rulers and ruled alike believe in the principle of authority,
of hierarchy, of power."_ [Colin Ward, **Anarchy in Action**, p. 15] With this
in mind, we present in this section of the FAQ our arguments to challenge this
"consensus," to present the case why we should become anarchists, why
authoritarian social relationships and organisations are not in our interests.

Needless to say, this task is not easy. No ruling class could survive unless
the institutions which empower it are generally accepted by those subject to
them. This is achieved by various means -- by propaganda, the so-called
education system, by tradition, by the media, by the general cultural
assumptions of a society. In this way the dominant ideas in society are those
of the dominant elite. This means that any social movement needs to combat
these ideas before trying to end them:

> _ "People often do not even recognise the existence of systems of oppression
and domination. They have to try to struggle to gain their rights within the
systems in which they live before they even perceive that there is repression.
Take a look at the women's movement. One of the first steps in the development
of the women's movement was so-called 'consciousness raising efforts.' Try to
get women to perceive that it is not the natural state of the world for them
to be dominated and controlled. My grandmother couldn't join the women's
movement, since she didn't feel any oppression, in some sense. That's just the
way life was, like the sun rises in the morning. Until people can realise that
it is not like the sun rising, that it can be changed, that you don't have to
follow orders, that you don't have to be beaten, until people can perceive
that there is something wrong with that, until that is overcome, you can't go
on. And one of the ways to do that is to try to press reforms within the
existing systems of repression, and sooner or later you find that you will
have to change them."_ [Noam Chomsky, **Anarchism Interview**]

This means, as Malatesta stressed, that anarchists _"first task therefore must
be to persuade people."_ This means that we _"must make people aware of the
misfortunes they suffer and of their chances to destroy them . . . To those
who are cold and hungry we will demonstrate how possible and easy it would be
to assure everybody their material needs. To those who are oppressed and
despised we shall show how it is possible to live happily in a world of people
who are free and equal . . . And when we will have succeeded in arousing the
sentiment of rebellion in the minds of men [and women] against the avoidable
and unjust evils from which we suffer in society today, and in getting them to
understand how they are caused and how it depends on human will to rid
ourselves of them"_ then we will be able to unite and change them for the
better. [**Errico Malatesta: His Life and Ideas**, pp. 185-6]

So we must explain **why** we want to change the system. From this discussion,
it will become apparent why anarchists are dissatisfied with the very limited
amount of freedom in modern society and why they want to create a truly free
society. In the words of Noam Chomsky, the anarchist critique of modern
society means:

> _"to seek out and identify structures of authority, hierarchy, and
domination in every aspect of life, and to challenge them; unless a
justification for them can be given, they are illegitimate, and should be
dismantled, to increase the scope of human freedom. That includes political
power, ownership and management, relations among men and women, parents and
children, our control over the fate of future generations (the basic moral
imperative behind the environmental movement. . .), and much else. Naturally
this means a challenge to the huge institutions of coercion and control: the
state, the unaccountable private tyrannies that control most of the domestic
and international economy [i.e. capitalist corporations and companies], and so
on. But not only these."_ [**Marxism, Anarchism, and Alternative Futures**, p.
775]

This task is made easier by the fact that the _"dominating class"_ has **not**
_"succeeded in reducing all its subjects to passive and unconscious
instruments of its interests."_ This means that where there is oppression and
exploitation there is also resistance -- and hope. Even when those oppressed
by hierarchical social relations generally accept it, those institutions
cannot put out the spark of freedom totally. Indeed, they help produce the
spirit of revolt by their very operation as people finally say enough is
enough and stand up for their rights. Thus hierarchical societies _"contain
organic contradictions and [these] are like the germs of death"_ from which
_"the possibility of progress"_ springs. [Malatesta, **Op. Cit.**, pp. 186-7]

Anarchists, therefore, combine their critique of existing society with active
participation in the on-going struggles which exist in any hierarchical
struggle. As we discuss in [section J](secJcon.md), we urge people to take
_**direct action**_ to fight oppression. Such struggles change those who take
part in them, breaking the social conditioning which keeps hierarchical
society going and making people aware of other possibilities, aware that other
worlds are possible and that we do not have to live like this. Thus struggle
is the practical school of anarchism, the means by which the preconditions of
an anarchist society are created. Anarchists seek to learn from such struggles
while, at the same time, propagating our ideas within them and encouraging
them to develop into a general struggle for social liberation and change.

Thus the natural resistance of the oppressed to their oppression encourages
this process of justification Chomsky (and anarchism) calls for, this critical
evaluation of authority and domination, this undermining of what previously
was considered "natural" or "common-sense" **until we started to question
it.** As noted above, an essential part of this process is to encourage direct
action by the oppressed against their oppressors as well as encouraging the
anarchistic tendencies and awareness that exist (to a greater or lesser
degree) in any hierarchical society. The task of anarchists is to encourage
such struggles and the questioning their produce of society and the way it
works. We aim to encourage people to look at the root causes of the social
problems they are fighting, to seek to change the underlying social
institutions and relationships which produce them. We seek to create an
awareness that oppression can not only be fought, but ended, and that the
struggle against an unjust system creates the seeds of the society that will
replace it. In other words, we seek to encourage hope and a positive vision of
a better world.

However, this section of the FAQ is concerned directly with the critical or
"negative" aspect of anarchism, the exposing of the evil inherent in all
authority, be it from state, property or whatever and why, consequently,
anarchists seek _"the destruction of power, property, hierarchy and
exploitation."_ [Murray Bookchin, **Post-Scarcity Anarchism**, p. 11] Later
sections will indicate how, after analysing the world, anarchists plan to
change it constructively, but some of the constructive core of anarchism will
be seen even in this section. After this broad critique of the current system,
we move onto more specific areas. [Section C](secCcon.md) explains the
anarchist critique of the economics of capitalism. [Section D](secDcon.md)
discusses how the social relationships and institutions described in this
section impact on society as a whole. [Section E](secEcon.md) discusses the
causes (and some suggested solutions) to the ecological problems we face.

[‹ Section B - Why do anarchists oppose the current system?](secBcon.md "Go
to previous page" ) [up](secBcon.md "Go to parent page" ) [B.1 Why are
anarchists against authority and hierarchy? ›](secB1.md "Go to next page" )

