/*
 * Copyright (c) 2003, 2007-11 Matteo Frigo
 * Copyright (c) 2003, 2007-11 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sun Nov 25 07:39:45 EST 2012 */

#include "codelet-rdft.h"

#ifdef HAVE_FMA

/* Generated by: ../../../genfft/gen_r2cf.native -fma -reorder-insns -schedule-for-pipeline -compact -variables 4 -pipeline-latency 4 -n 4 -name r2cf_4 -include r2cf.h */

/*
 * This function contains 6 FP additions, 0 FP multiplications,
 * (or, 6 additions, 0 multiplications, 0 fused multiply/add),
 * 7 stack variables, 0 constants, and 8 memory accesses
 */
#include "r2cf.h"

static void r2cf_4(R *R0, R *R1, R *Cr, R *Ci, stride rs, stride csr, stride csi, INT v, INT ivs, INT ovs)
{
     {
	  INT i;
	  for (i = v; i > 0; i = i - 1, R0 = R0 + ivs, R1 = R1 + ivs, Cr = Cr + ovs, Ci = Ci + ovs, MAKE_VOLATILE_STRIDE(16, rs), MAKE_VOLATILE_STRIDE(16, csr), MAKE_VOLATILE_STRIDE(16, csi)) {
	       E T1, T2, T4, T5, T3, T6;
	       T1 = R0[0];
	       T2 = R0[WS(rs, 1)];
	       T4 = R1[0];
	       T5 = R1[WS(rs, 1)];
	       Cr[WS(csr, 1)] = T1 - T2;
	       T3 = T1 + T2;
	       Ci[WS(csi, 1)] = T5 - T4;
	       T6 = T4 + T5;
	       Cr[0] = T3 + T6;
	       Cr[WS(csr, 2)] = T3 - T6;
	  }
     }
}

static const kr2c_desc desc = { 4, "r2cf_4", {6, 0, 0, 0}, &GENUS };

void X(codelet_r2cf_4) (planner *p) {
     X(kr2c_register) (p, r2cf_4, &desc);
}

#else				/* HAVE_FMA */

/* Generated by: ../../../genfft/gen_r2cf.native -compact -variables 4 -pipeline-latency 4 -n 4 -name r2cf_4 -include r2cf.h */

/*
 * This function contains 6 FP additions, 0 FP multiplications,
 * (or, 6 additions, 0 multiplications, 0 fused multiply/add),
 * 7 stack variables, 0 constants, and 8 memory accesses
 */
#include "r2cf.h"

static void r2cf_4(R *R0, R *R1, R *Cr, R *Ci, stride rs, stride csr, stride csi, INT v, INT ivs, INT ovs)
{
     {
	  INT i;
	  for (i = v; i > 0; i = i - 1, R0 = R0 + ivs, R1 = R1 + ivs, Cr = Cr + ovs, Ci = Ci + ovs, MAKE_VOLATILE_STRIDE(16, rs), MAKE_VOLATILE_STRIDE(16, csr), MAKE_VOLATILE_STRIDE(16, csi)) {
	       E T1, T2, T3, T4, T5, T6;
	       T1 = R0[0];
	       T2 = R0[WS(rs, 1)];
	       T3 = T1 + T2;
	       T4 = R1[0];
	       T5 = R1[WS(rs, 1)];
	       T6 = T4 + T5;
	       Cr[WS(csr, 1)] = T1 - T2;
	       Ci[WS(csi, 1)] = T5 - T4;
	       Cr[WS(csr, 2)] = T3 - T6;
	       Cr[0] = T3 + T6;
	  }
     }
}

static const kr2c_desc desc = { 4, "r2cf_4", {6, 0, 0, 0}, &GENUS };

void X(codelet_r2cf_4) (planner *p) {
     X(kr2c_register) (p, r2cf_4, &desc);
}

#endif				/* HAVE_FMA */
