% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decoupleR-pre.R
\name{.fit_preprocessing}
\alias{.fit_preprocessing}
\title{Pre-processing for methods that fit networks.}
\usage{
.fit_preprocessing(network, mat, center, na.rm, sparse)
}
\arguments{
\item{network}{Tibble or dataframe with edges and it's associated metadata.}

\item{mat}{Matrix to evaluate (e.g. expression matrix).
Target nodes in rows and conditions in columns.
\code{rownames(mat)} must have at least one intersection with the elements
in \code{network} \code{.target} column.}

\item{center}{Logical value indicating if \code{mat} must be centered by
\code{\link[base:colSums]{base::rowMeans()}}.}

\item{na.rm}{Should missing values (including NaN) be omitted from the
calculations of \code{\link[base:colSums]{base::rowMeans()}}?}

\item{sparse}{Deprecated parameter.}
}
\value{
A named list of matrices to evaluate in methods that fit models, like
\code{.mlm_analysis()}.
\itemize{
\item mat: Features as rows and samples as columns.
\item mor_mat: Features as rows and columns as source.
}
}
\description{
\itemize{
\item If \code{center} is true, then the expression values are centered by the
mean of expression across the samples.
}
}
\examples{
inputs_dir <- system.file("testdata", "inputs", package = "decoupleR")
mat <- readRDS(file.path(inputs_dir, "mat.rds"))
net <- readRDS(file.path(inputs_dir, "net.rds"))
net <- rename_net(net, source, target, mor)
.fit_preprocessing(net, mat, center = FALSE, na.rm = FALSE, sparse = FALSE)
}
