% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sigmas-plotting.r
\name{plot.Sigmas}
\alias{plot.Sigmas}
\alias{plot,Sigmas,missing-method}
\title{Plot \link{Sigmas} object}
\usage{
\S4method{plot}{Sigmas,missing}(
  x,
  col = par("fg"),
  col_highlight = "#E41A1C",
  col_line = "#999999",
  type = c("b", "b"),
  pch = c(par("pch"), 4L),
  only_dim = FALSE,
  ...,
  xlab = NULL,
  ylab = NULL,
  main = ""
)
}
\arguments{
\item{x}{Sigmas object to plot}

\item{col}{Vector of bar colors or single color for all bars}

\item{col_highlight}{Color for highest bar. Overrides col}

\item{col_line}{Color for the line and its axis}

\item{type}{Plot type of both lines. Can be a vector of length 2 to specify both separately (default: 'b' aka \dQuote{both lines and points})}

\item{pch}{Point identifier for both lines. Can be a vector of length 2 to specify both separately (default: \code{par(pch)} and 4 (a \sQuote{\eqn{\times}}))}

\item{only_dim}{logical. If TRUE, only plot the derivative line}

\item{...}{Options passed to the call to plot}

\item{xlab}{X label. NULL to use default}

\item{ylab}{Either one y label or y labels for both plots. NULL to use both defauts, a NULL in a list of length 2 to use one default.}

\item{main}{Title of the plot}
}
\value{
This method plots a Sigma object to the current device and returns nothing/NULL
}
\description{
Plot \link{Sigmas} object
}
\examples{
data(guo)
sigs <- find_sigmas(guo)
plot(sigs)

}
