% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uniquifyFeatureNames.R
\name{uniquifyFeatureNames}
\alias{uniquifyFeatureNames}
\title{Make feature names unique}
\usage{
uniquifyFeatureNames(ID, names)
}
\arguments{
\item{ID}{A character vector of unique identifiers.}

\item{names}{A character vector of feature names.}
}
\value{
A character vector of unique-ified feature names.
}
\description{
Combine a user-interpretable feature name (e.g., gene symbol) with a standard identifier that is guaranteed to be unique and valid (e.g., Ensembl) for use as row names.
}
\details{
This function will attempt to use \code{names} if it is unique.
If not, it will append the \code{_ID} to any non-unique value of \code{names}.
Missing \code{names} will be replaced entirely by \code{ID}. 

The output is guaranteed to be unique, assuming that \code{ID} is also unique.
This can be directly used as the row names of a SingleCellExperiment object.
}
\examples{
uniquifyFeatureNames(
  ID=paste0("ENSG0000000", 1:5),
  names=c("A", NA, "B", "C", "A")
)
}
\author{
Aaron Lun
}
