% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snapclust.choose.k.R
\name{snapclust.choose.k}
\alias{snapclust.choose.k}
\title{Choose the number of clusters for snapclust using AIC, BIC or AICc}
\usage{
snapclust.choose.k(max, ..., IC = AIC, IC.only = TRUE)
}
\arguments{
\item{max}{An integer indicating the maximum number of clusters to seek;
\code{\link{snapclust}} will be run for all k from 2 to max.}

\item{...}{Arguments passed to \code{\link{snapclust}}.}

\item{IC}{A function computing the information criterion for
\code{\link{snapclust}} objects. Available statistics are
\code{AIC} (default), \code{AICc}, and \code{BIC}.}

\item{IC.only}{A logical (TRUE by default) indicating if IC values only
should be returned; if \code{FALSE}, full \code{snapclust} objects are
returned.}
}
\description{
This function implements methods for investigating the optimal number of
genetic clusters ('k') using the fast maximum-likelihood genetic clustering
approach described in Beugin et al (2018). The method runs
\code{\link{snapclust}} for varying values of 'k', and computes the requested
summary statistics for each clustering solution to assess goodness of
fit. The method is fully documented in a dedicated tutorial which can be
accessed using \code{adegenetTutorial("snapclust")}.
}
\details{
The method is described in Beugin et al (2018) A fast likelihood
  solution to the genetic clustering problem. Methods in Ecology and
  Evolution \doi{10.1111/2041-210X.12968}. A dedicated
  tutorial is available by typing \code{adegenetTutorial("snapclust")}.
}
\seealso{
\code{\link{snapclust}} to generate individual clustering solutions,
and \code{\link{BIC.snapclust}} for computing BIC for \code{snapclust}
objects.
}
\author{
Thibaut Jombart \email{thibautjombart@gmail.com}
}
