% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loo.R
\name{loo_model_weights.brmsfit}
\alias{loo_model_weights.brmsfit}
\alias{loo_model_weights}
\title{Model averaging via stacking or pseudo-BMA weighting.}
\usage{
\method{loo_model_weights}{brmsfit}(x, ..., model_names = NULL)
}
\arguments{
\item{x}{A \code{brmsfit} object.}

\item{...}{More \code{brmsfit} objects or further arguments
passed to the underlying post-processing functions.
In particular, see \code{\link{prepare_predictions}} for further
supported arguments.}

\item{model_names}{If \code{NULL} (the default) will use model names 
derived from deparsing the call. Otherwise will use the passed 
values as model names.}
}
\value{
A named vector of model weights.
}
\description{
Compute model weights for \code{brmsfit} objects via stacking 
or pseudo-BMA weighting. For more details, see
\code{\link[loo:loo_model_weights]{loo::loo_model_weights}}.
}
\examples{
\dontrun{
# model with population-level effects only
fit1 <- brm(rating ~ treat + period + carry,
            data = inhaler, family = "gaussian")
# model with an additional varying intercept for subjects
fit2 <- brm(rating ~ treat + period + carry + (1|subject),
            data = inhaler, family = "gaussian")
loo_model_weights(fit1, fit2)   
}  

}
