% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step-subset-select.R
\name{select.dtplyr_step}
\alias{select.dtplyr_step}
\title{Subset columns using their names}
\usage{
\method{select}{dtplyr_step}(.data, ...)
}
\arguments{
\item{.data}{A \code{\link[=lazy_dt]{lazy_dt()}}.}

\item{...}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> One or more unquoted
expressions separated by commas. Variable names can be used as if they
were positions in the data frame, so expressions like \code{x:y} can
be used to select a range of variables.}
}
\description{
This is a method for the dplyr \code{\link[=select]{select()}} generic. It is translated to
the \code{j} argument of \verb{[.data.table}.
}
\examples{
library(dplyr, warn.conflicts = FALSE)

dt <- lazy_dt(data.frame(x1 = 1, x2 = 2, y1 = 3, y2 = 4))

dt \%>\% select(starts_with("x"))
dt \%>\% select(ends_with("2"))
dt \%>\% select(z1 = x1, z2 = x2)
}
