% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpret_cohens_g.R
\name{interpret_cohens_g}
\alias{interpret_cohens_g}
\title{Interpret Cohen's g}
\usage{
interpret_cohens_g(g, rules = "cohen1988", ...)
}
\arguments{
\item{g}{Value or vector of effect size values.}

\item{rules}{Can be \code{"cohen1988"} (default) or a custom set of \code{\link[=rules]{rules()}}.}

\item{...}{Not directly used.}
}
\description{
Interpret Cohen's g
}
\note{
"\emph{Since \strong{g} is so transparently clear a unit, it is expected that
workers in any given substantive area of the behavioral sciences will very
frequently be able to set relevant [effect size] values without the
proposed conventions, or set up conventions of their own which are suited
to their area of inquiry.}" - Cohen, 1988, page 147.
}
\section{Rules}{


Rules apply to equally to positive and negative \emph{g} (i.e., they are given as
absolute values).
\itemize{
\item Cohen (1988) (\code{"cohen1988"}; default)
\itemize{
\item \strong{d < 0.05} - Very small
\item \strong{0.05 <= d < 0.15} - Small
\item \strong{0.15 <= d < 0.25} - Medium
\item \strong{d >= 0.25} - Large
}
}
}

\examples{
interpret_cohens_g(.02)
interpret_cohens_g(c(.3, .15))

}
\references{
\itemize{
\item Cohen, J. (1988). Statistical power analysis for the behavioral sciences
(2nd Ed.). New York: Routledge.
}
}
