% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/when.R
\name{when}
\alias{when}
\title{When}
\usage{
when(object)
}
\arguments{
\item{object}{the \code{object} to extract the time slot from.}
}
\value{
A \code{character} vector of length one.
}
\description{
Help method to extract the time as a character string from a
git_commit, git_signature, git_tag and git_time object.
}
\examples{
\dontrun{
## Initialize a temporary repository
path <- tempfile(pattern="git2r-")
dir.create(path)
repo <- init(path)

## Create a first user and commit a file
config(repo, user.name="Alice", user.email="alice@example.org")
writeLines("Hello world!", file.path(path, "example.txt"))
add(repo, "example.txt")
commit(repo, "First commit message")

## Create tag
tag(repo, "Tagname", "Tag message")

when(commits(repo)[[1]])
when(tags(repo)[[1]])
}
}
