% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sizing.R
\name{sizingPolicy}
\alias{sizingPolicy}
\title{Create a widget sizing policy}
\usage{
sizingPolicy(
  defaultWidth = NULL,
  defaultHeight = NULL,
  padding = NULL,
  viewer.defaultWidth = NULL,
  viewer.defaultHeight = NULL,
  viewer.padding = NULL,
  viewer.fill = TRUE,
  viewer.suppress = FALSE,
  viewer.paneHeight = NULL,
  browser.defaultWidth = NULL,
  browser.defaultHeight = NULL,
  browser.padding = NULL,
  browser.fill = FALSE,
  browser.external = FALSE,
  knitr.defaultWidth = NULL,
  knitr.defaultHeight = NULL,
  knitr.figure = TRUE
)
}
\arguments{
\item{defaultWidth}{The default width used to display the widget. This
parameter specifies the default width for viewing in all contexts (browser,
viewer, and knitr) unless it is specifically overridden with e.g.
\code{browser.defaultWidth}.}

\item{defaultHeight}{The default height used to display the widget. This
parameter specifies the default height for viewing in all contexts
(browser, viewer, and knitr) unless it is specifically overridden with e.g.
\code{browser.defaultHeight}.}

\item{padding}{Padding around the widget (in pixels). This parameter
specifies the padding for viewing in all contexts (browser and viewer)
unless it is specifically overriden by e.g. \code{browser.padding}.}

\item{viewer.defaultWidth}{The default width used to display the widget
within the RStudio Viewer.}

\item{viewer.defaultHeight}{The default height used to display the widget
within the RStudio Viewer.}

\item{viewer.padding}{Padding around the widget when displayed in the RStudio
Viewer (defaults to 15 pixels).}

\item{viewer.fill}{When displayed in the RStudio Viewer, automatically size
the widget to the viewer dimensions (note that \code{viewer.padding} is
still applied). Default to \code{TRUE}.}

\item{viewer.suppress}{Never display the widget within the RStudio Viewer
(useful for widgets that require a large amount of space for rendering).
Defaults to \code{FALSE}.}

\item{viewer.paneHeight}{Request that the RStudio Viewer be forced to a
specific height when displaying this widget.}

\item{browser.defaultWidth}{The default width used to display the widget
within a standalone web browser.}

\item{browser.defaultHeight}{The default height used to display the widget
within a standalone web browser.}

\item{browser.padding}{Padding around the widget when displayed in a
standalone browser (defaults to 40 pixels).}

\item{browser.fill}{When displayed in a standalone web browser, automatically
size the widget to the browser dimensions (note that \code{browser.padding}
is still applied). Defaults to \code{FALSE}.}

\item{browser.external}{When displaying in a browser, always use an external
browser (via \code{browseURL()}). Defaults to \code{FALSE}, which will
result in the use of an internal browser within RStudio v1.1 and higher.}

\item{knitr.defaultWidth}{The default width used to display the widget within
documents generated by knitr (e.g. R Markdown).}

\item{knitr.defaultHeight}{The default height used to display the widget
within documents generated by knitr (e.g. R Markdown).}

\item{knitr.figure}{Apply the default knitr fig.width and fig.height to the
widget when it's rendered within R Markdown documents. Defaults to
\code{TRUE}.}
}
\value{
A widget sizing policy
}
\description{
Define the policy by which HTML widgets will be sized in various containers
(e.g. Browser, RStudio Viewer, R Markdown, Shiny). Note that typically
widgets can accept the default sizing policy (or override only one or two
aspects of it) and get satisfactory sizing behavior via the automatic sizing
logic built into the htmlwidgets framework (see the notes below for the most
typical exceptions to this).
}
\details{
The default HTML widget sizing policy treats the widget with the same sizing
semantics as an R plot. When printed at the R console the widget is displayed
within the RStudio Viewer and sized to fill the Viewer pane (modulo any
padding). When rendered inside an R Markdown document the widget is sized
based on the default size of figures in the document.

You might need to change the default behavior if your widget is extremely
large. In this case you might specify \code{viewer.suppress = TRUE} and
\code{knitr.figure = FALSE} as well provide for a larger default width and
height for knitr.

You also might need to change the default behavior if you widget already
incorporates padding. In this case you might specify \code{viewer.padding =
0}.

For additional details on widget sizing:

\code{vignette("develop_sizing", package = "htmlwidgets")}
}
