% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary2.R
\name{summary2}
\alias{summary2}
\alias{summary2.lm}
\alias{summary2.gls}
\alias{summary2.lme}
\alias{summary2.lvmfit}
\alias{summary2.lm2}
\alias{summary2.gls2}
\alias{summary2.lme2}
\alias{summary2.lvmfit2}
\title{Summary with Small Sample Correction}
\usage{
summary2(object, ...)

\method{summary2}{lm}(object, df = TRUE, bias.correct = TRUE, ...)

\method{summary2}{gls}(object, df = TRUE, bias.correct = TRUE,
  cluster = NULL, ...)

\method{summary2}{lme}(object, df = TRUE, bias.correct = TRUE, ...)

\method{summary2}{lvmfit}(object, df = TRUE, bias.correct = TRUE, ...)

\method{summary2}{lm2}(object, digit = max(3, getOption("digit")),
  robust = FALSE, df = TRUE, ...)

\method{summary2}{gls2}(object, digit = max(3, getOption("digit")),
  robust = FALSE, df = TRUE, ...)

\method{summary2}{lme2}(object, digit = max(3, getOption("digit")),
  robust = FALSE, df = TRUE, ...)

\method{summary2}{lvmfit2}(object, cluster = NULL, robust = FALSE,
  df = TRUE, ...)
}
\arguments{
\item{object}{a \code{gls}, \code{lme} or \code{lvm} object.}

\item{...}{arguments passed to the \code{summary} method of the object.}

\item{df}{[logical] should the degree of freedoms of the Wald statistic be computed using the Satterthwaite correction?
Otherwise the degree of freedoms are set to \code{Inf}, i.e. a normal distribution is used instead of a Student's t distribution when computing the p-values.}

\item{bias.correct}{[logical] should the standard errors of the coefficients be corrected for small sample bias?
See \code{\link{sCorrect}} for more details.}

\item{cluster}{[integer vector] the grouping variable relative to which the observations are iid.}

\item{digit}{[integer > 0] the number of decimal places to use when displaying the summary.}

\item{robust}{[logical] should the robust standard errors be used instead of the model based standard errors?}
}
\description{
Summary with small sample correction.
}
\details{
\code{summary2} is the same as \code{summary}
except that it first computes the small sample correction (but does not store it).
So if \code{summary2} is to be called several times,
it is more efficient to pre-compute the quantities for the small sample correction
using \code{sCorrect} and then call \code{summary2}.
}
\examples{
m <- lvm(Y~X1+X2)
set.seed(10)
d <- lava::sim(m, 2e1)

## Gold standard
summary(lm(Y~X1+X2, d))$coef

## gls models
library(nlme)
e.gls <- gls(Y~X1+X2, data = d, method = "ML")
summary(e.gls)$tTable
sCorrect(e.gls, cluster = 1:NROW(d)) <- FALSE ## no small sample correction
summary2(e.gls)$tTable

sCorrect(e.gls, cluster = 1:NROW(d)) <- TRUE ## small sample correction
summary2(e.gls)$tTable

## lvm models
e.lvm <- estimate(m, data = d)
summary(e.lvm)$coef

sCorrect(e.lvm) <- FALSE ## no small sample correction
summary2(e.lvm)$coef

sCorrect(e.lvm) <- TRUE ## small sample correction
summary2(e.lvm)$coef

}
\seealso{
\code{\link{sCorrect}} for more detail about the small sample correction.
}
\concept{small sample inference}
