% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tune_Data.R
\name{tune_Data}
\alias{tune_Data}
\title{Tune data for experimental purpose}
\usage{
tune_Data(data, decrease.error = 0, increase.data = 0)
}
\arguments{
\item{data}{\code{\link{data.frame}} (\bold{required}): input values,
structure: data (\code{values[,1]}) and data error (\code{values [,2]}) are
required}

\item{decrease.error}{\code{\link{numeric}}: factor by which the error
is decreased, ranges between 0 and 1.}

\item{increase.data}{\code{\link{numeric}}: factor by which the error
is decreased, ranges between 0 and inf.}
}
\value{
Returns a \code{\link{data.frame}} with tuned values.
}
\description{
The error can be reduced and sample size increased for specific purpose.
}
\note{
You should not use this function to improve your poor data set!
}
\section{Function version}{
 0.5.0 (2017-06-29 18:40:14)
}

\examples{
## load example data set
data(ExampleData.DeValues, envir = environment())
x <- ExampleData.DeValues$CA1

## plot original data
plot_AbanicoPlot(data = x,
                 summary = c("n", "mean"))

## decrease error by 10 \%
plot_AbanicoPlot(data = tune_Data(x, decrease.error = 0.1),
                 summary = c("n", "mean"))

## increase sample size by 200 \%
#plot_AbanicoPlot(data = tune_Data(x, increase.data = 2) ,
#                summary = c("n", "mean"))


} 

\section{How to cite}{
Dietze, M. (2017). tune_Data(): Tune data for experimental purpose. Function version 0.5.0. In: Kreutzer, S., Dietze, M., Burow, C., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J. (2017). Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 0.7.5. https://CRAN.R-project.org/package=Luminescence
}

\references{
#
}
\seealso{
#
}
\author{
Michael Dietze, GFZ Potsdam (Germany)
\cr R Luminescence Package Team}
\keyword{manip}
