% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probabilistic.R
\name{committorAB}
\alias{committorAB}
\title{Calculates committor of a markovchain object with respect to set A, B}
\usage{
committorAB(object,A,B,p)
}
\arguments{
\item{object}{a markovchain class object}

\item{A}{a set of states}

\item{B}{a set of states}

\item{p}{initial state (default value : 1)}
}
\value{
Return a vector of probabilities in case initial state is not provided else returns a number
}
\description{
Returns the probability of hitting states rom set A before set B 
with different initial states
}
\details{
The function solves a system of linear equations to calculate probaility that the process hits
a state from set A before any state from set B
}
\examples{
transMatr <- matrix(c(0,0,0,1,0.5,
                      0.5,0,0,0,0,
                      0.5,0,0,0,0,
                      0,0.2,0.4,0,0,
                      0,0.8,0.6,0,0.5),
                      nrow = 5)
object <- new("markovchain", states=c("a","b","c","d","e"),transitionMatrix=transMatr)
committorAB(object,c(5),c(3))

}
