% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/disk.R
\name{ps_disk_usage}
\alias{ps_disk_usage}
\title{Disk usage statistics, per partition}
\usage{
ps_disk_usage(paths = ps_disk_partitions()$mountpoint)
}
\arguments{
\item{paths}{The mounted file systems to list. By default all file
systems returned by \code{\link[=ps_disk_partitions]{ps_disk_partitions()}} is listed.}
}
\value{
A data frame with columns \code{mountpoint}, \code{total}, \code{used},
\code{available} and \code{capacity}.
}
\description{
The output is similar to the Unix \code{df} command.
}
\details{
Note that on Unix a small percentage of the disk space (5\% typically)
is reserved for the superuser. \code{ps_disk_usage()} returns the space
available to the calling user.
}
\examples{
\dontshow{if (ps::ps_is_supported() && ! ps:::is_cran_check()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
ps_disk_usage()
\dontshow{\}) # examplesIf}
}
\seealso{
Other disk functions: 
\code{\link{ps_disk_io_counters}()},
\code{\link{ps_disk_partitions}()}
}
\concept{disk functions}
