% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adverb-negate.R
\name{negate}
\alias{negate}
\title{Negate a predicate function so it selects what it previously rejected}
\usage{
negate(.p)
}
\arguments{
\item{.p}{A predicate function (i.e. a function that returns either \code{TRUE}
or \code{FALSE}) specified in one of the following ways:
\itemize{
\item A named function, e.g. \code{is.character}.
\item An anonymous function, e.g. \verb{\\(x) all(x < 0)} or \code{function(x) all(x < 0)}.
\item A formula, e.g. \code{~ all(.x < 0)}. You must use \code{.x} to refer to the first
argument). Only recommended if you require backward compatibility with
older versions of R.
}}
}
\value{
A new predicate function.
}
\description{
Negating a function changes \code{TRUE} to \code{FALSE} and \code{FALSE} to \code{TRUE}.
}
\section{Adverbs}{
This function is called an adverb because it modifies the effect of a
function (a verb). If you'd like to include a function created an adverb
in a package, be sure to read \link{faq-adverbs-export}.
}

\examples{
x <- list(x = 1:10, y = rbernoulli(10), z = letters)
x |> keep(is.numeric) |> names()
x |> keep(negate(is.numeric)) |> names()
# Same as
x |> discard(is.numeric)
}
\seealso{
Other adverbs: 
\code{\link{auto_browse}()},
\code{\link{compose}()},
\code{\link{insistently}()},
\code{\link{partial}()},
\code{\link{possibly}()},
\code{\link{quietly}()},
\code{\link{safely}()},
\code{\link{slowly}()}
}
\concept{adverbs}
