% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{toTz}
\alias{toTz}
\title{Shift datetime object from one timezone to another}
\usage{
toTz(dtv, tzfrom, tzto, verbose = FALSE)
}
\arguments{
\item{dtv}{A DatetimeVector object specifying when the difference is to be computed.}

\item{tzfrom}{The first time zone as a character vector.}

\item{tzto}{The second time zone as a character vector.}

\item{verbose}{A boolean toggle indicating whether more verbose operations
are desired, default is \code{FALSE}.}
}
\value{
A DatetimeVector object with the given (civil time) determined by the
incoming object (and its timezone) shifted to the target timezone.
}
\description{
Change from one given timezone to another.
}
\details{
Time zone offsets vary by date, and this helper function converts
a Datetime object from one given timezone to another.
}
\examples{
\dontrun{
toTz(Sys.time(), "America/New_York", "Europe/London")
# this redoes the 'Armstrong on the moon in NYC and Sydney' example
toTz(ISOdatetime(1969,7,20,22,56,0,tz="UTC"), "America/New_York", "Australia/Sydney", verbose=TRUE)
# we can also explicitly format for Sydney time 
format(toTz(ISOdatetime(1969,7,20,22,56,0,tz="UTC"), 
            "America/New_York", "Australia/Sydney", verbose=TRUE), 
       tz="Australia/Sydney")
}
}
\author{
Dirk Eddelbuettel
}
