% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform.R
\name{st_transform}
\alias{st_transform}
\alias{st_transform.stars}
\alias{st_transform_proj.stars}
\title{transform features, or warp/resample grids in stars objects to a new coordinate reference system}
\usage{
\method{st_transform}{stars}(x, crs, ...)

\method{st_transform_proj}{stars}(x, crs, ...)
}
\arguments{
\item{x}{object of class \code{stars}, with either raster or simple feature geometries}

\item{crs}{object of class \code{crs} with target crs}

\item{...}{ignored}
}
\description{
transform features, or warp/resample grids in stars objects to a new coordinate reference system
}
\details{
For simple feature dimensions, \link[sf]{st_transform} is called, leading to lossless transformation. For gridded spatial data, a curvilinear grid with transformed grid cell (centers) is returned. To convert this to a regular grid in the new \code{CRS}, use \link{st_warp}.
}
\examples{
geomatrix = system.file("tif/geomatrix.tif", package = "stars")
(x = read_stars(geomatrix))
new = st_crs(4326)
y = st_transform(x, new)
plot(st_transform(st_as_sfc(st_bbox(x)), new), col = NA, border = 'red')
plot(st_as_sfc(y, as_points=FALSE), col = NA, border = 'green', axes = TRUE, add = TRUE)
image(y, col = heat.colors(12), add = TRUE)
plot(st_as_sfc(y, as_points=TRUE), pch=3, cex=.5, col = 'blue', add = TRUE)
plot(st_transform(st_as_sfc(x, as_points=FALSE), new), add = TRUE)
}
\seealso{
\link{st_warp}
}
