% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecation_utils.R
\name{deprecation-utilities}
\alias{deprecation-utilities}
\alias{.Deprecate_once}
\alias{.Deprecate_method}
\title{Utilities to help with deprecating functions.}
\usage{
.Deprecate_once(...)

.Deprecate_method(generic, class)
}
\arguments{
\item{...}{arguments passed to \code{\link[=.Deprecated]{.Deprecated()}}.}

\item{generic, class}{strings giving the generic function name and
class name of the function to be deprecated.}
}
\description{
\code{.Deprecate_once} calls \code{\link[=.Deprecated]{.Deprecated()}}, passing all its arguments
through, but only the first time it's called.

\code{.Deprecate_method} calls
\code{\link[=.Deprecated]{.Deprecated()}}, but only if a method has been called by name,
i.e., \code{\var{METHOD}.\var{CLASS}}. Like \code{.Deprecate_once} it
only issues a warning the first time.
}
\examples{
\dontrun{
options(warn=1) # Print warning immediately after the call.
f <- function(){
   .Deprecate_once("new_f")
}
f() # Deprecation warning
f() # No deprecation warning
}
\dontrun{
options(warn=1) # Print warning immediately after the call.
summary.packageDescription <- function(object, ...){
   .Deprecate_method("summary", "packageDescription")
   invisible(object)
}

summary(packageDescription("statnet.common")) # No warning.
summary.packageDescription(packageDescription("statnet.common")) # Warning.
summary.packageDescription(packageDescription("statnet.common")) # No warning.
}
}
