% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect.r
\name{str_starts}
\alias{str_starts}
\alias{str_ends}
\title{Detect the presence or absence of a pattern at the beginning or end of a
string.}
\usage{
str_starts(string, pattern, negate = FALSE)

str_ends(string, pattern, negate = FALSE)
}
\arguments{
\item{string}{Input vector. Either a character vector, or something
coercible to one.}

\item{pattern}{Pattern with which the string starts or ends.

The default interpretation is a regular expression, as described in
\link[stringi:stringi-search-regex]{stringi::stringi-search-regex}. Control options with \code{\link[=regex]{regex()}}.

Match a fixed string (i.e. by comparing only bytes), using \code{\link[=fixed]{fixed()}}. This
is fast, but approximate. Generally, for matching human text, you'll want
\code{\link[=coll]{coll()}} which respects character matching rules for the specified locale.}

\item{negate}{If \code{TRUE}, return non-matching elements.}
}
\value{
A logical vector.
}
\description{
Vectorised over \code{string} and \code{pattern}.
}
\examples{
fruit <- c("apple", "banana", "pear", "pinapple")
str_starts(fruit, "p")
str_starts(fruit, "p", negate = TRUE)
str_ends(fruit, "e")
str_ends(fruit, "e", negate = TRUE)
}
\seealso{
\code{\link[=str_detect]{str_detect()}} which this function wraps when pattern is regex.
}
