#include "rheolef.h"
using namespace std;
using namespace rheolef;
#include "sphere.icc"
int main (int argc, char**argv) {
  environment rheolef(argc, argv);
  geo lambda (argv[1]);
  size_t d = lambda.dimension();
  space Xh (lambda, "P1");
  field phi_h = interpolate(Xh, phi);
  band gamma_h (phi_h);
  field phi_h_band = phi_h [gamma_h.band()];
  space Bh (gamma_h.band(), "P1");
  Bh.block ("isolated");
  Bh.unblock ("zero");
  trial u (Bh); test v (Bh);
  form  a  = integrate (gamma_h, u*v + dot(grad_s(u),grad_s(v)));
  field lh = integrate (gamma_h, f(d)*v);
  vector<vec<Float> > b (gamma_h.n_connected_component());
  vector<Float>       z (gamma_h.n_connected_component(), 0);
  for (size_t i = 0; i < b.size(); i++) {
    const domain& cci = gamma_h.band() ["cc"+itos(i)];
    field phi_h_cci (Bh, 0);
    phi_h_cci [cci] = phi_h_band [cci];
    b[i] = phi_h_cci.u();
  }
  csr<Float> A = { { a.uu(), trans(b)},
                   { b,         0    } };
  vec<Float> F =   { lh.u(),    z    };
  A.set_symmetry(true);
  solver sa = ldlt(A);
  vec<Float> U = sa.solve (F);
  field uh(Bh,0);
  uh.set_u() = U [range(0,uh.u().size())];
  dout << catchmark("phi") << phi_h
       << catchmark("u")   << uh;
}
