///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
#include "rheolef/skit.h"
#include "rheolef/the_clock.h"
using namespace rheolef;
using namespace std;

#define USE_NOT_MAIN // includes only the function:
#include "makefish.cc"
#include "makefish3d.cc"

void usage (char *progname) {
    cerr << progname << ": usage: " 
	 << progname << " [-3d] <block_size>" 
	 << endl;
    exit (1);
}
int
main(int argc, char**argv)
{
    bool use_3d = false;
    if (argc < 2) usage(argv[0]);
    
    unsigned int block_size = 0;
    if (strcmp (argv[1], "-3d") != 0) {
        block_size = atoi(argv[1]);
        if (block_size < 1) usage(argv[0]);
    } else {
        use_3d = true;
        if (argc < 3) usage(argv[0]);
        block_size = atoi(argv[2]);
        if (block_size < 1) usage(argv[0]);
    }
    warning_macro("makefish...");
    csr<Float> a;
    if (use_3d) {
	a = makefish3d (block_size);
    } else {
	a = makefish (block_size);
    }
    cerr << "problem_size = " << a.nrow() << endl;
    warning_macro("makefish done");

    warning_macro("compute exact solution...");
    vec<Float> x_ex(a.ncol());
    x_ex = 1;
    warning_macro("compute rhs...");
    vec<Float> b = a*x_ex;
    vec<Float> x(a.ncol());

    warning_macro("factorize...");
    Float cpu_fact = the_clock();
    ssk<Float> fa = ldlt(a);
    cpu_fact = the_clock() - cpu_fact;
    warning_macro("cpu_fact= " << cpu_fact);
    warning_macro("factorize done.");
    
    warning_macro("solve...");
    Float cpu_solve = the_clock();
    fa.solve (b, x);
    cpu_solve = the_clock() - cpu_solve;
    warning_macro("cpu_solve= " << cpu_solve);
    warning_macro("solve done.");

#ifdef TOCLEAN
    cout << "a = " << ml << a << endl;
    cout << "b = " << ml << b << endl;
    cout << "x_ex = " << ml << x_ex << endl;
    cout << "x = " << ml << x << endl;
#endif // TOCLEAN
    Float eps = 1e-7;
    Float err = norm(x-x_ex);
    // truncate mantisea to eps:
    Float round_err = int(err/eps)*eps;
    if (round_err != Float(0)) {
	cout << "error = " << err << endl;
	exit(1);
    } else {
        cerr << "error = " << err << endl;
    }
    return 0;
}
