///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
// usage:
//   find_close_vertex <geo>
//     => ouput for gnuplot
//   find_close_vertex <geo> x [y [z]]
//     => find a close vertex (not the nearest)
// Example:
//   mkgeo_grid -T 5 > box-5.geo
//   ./find_close_vertex_tst box-5.geo 1.2 0.5 0.5
//
#include "rheolef/geo_tree.h"
#include "rheolef/geo.h"
using namespace rheolef;
using namespace std;

int main(int argc, char** argv)
{
    const geo g(argv[1]);
    cerr << "deep_max = " << geo_tree::deep_max << endl;
    cerr << "coord_max = " << geo_tree::coord_max << endl;
    geo_tree t (g.map_dimension(), g.xmin(), g.xmax(),
	g.n_vertice(), g.begin_node(),
	g.size(), g.begin());
    // t.dump();
    if (argc == 2) {
	t.put_gnuplot();
	return 0;
    }
    point x;
    x[0] = (argc > 2) ? atof(argv[2]) : 0;
    x[1] = (argc > 3) ? atof(argv[3]) : 0;
    x[2] = (argc > 4) ? atof(argv[4]) : 0;
    bool no_plot = (argc > 5);

    size_t idx = t.find_close_vertex(x);
    point y = *(g.begin_node() + idx);
    cout << "nearest = " << y << endl;
    if (no_plot) return 0;
    cout << "set arrow from " << x[0] << "," << x[1]
         << " to "  << y[0] << "," << y[1] 
	 << " lt 4 lw 4 " << endl;
    return 0;
}
