///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
//
// This code presents "matvec" expressions
//
// also print matlab code for non-regression test purpose, i.e.
//
// usage: cat matrix.hb | blas2 -check | octave
//
# include "rheolef/skit.h"
using namespace rheolef;
using namespace std;

bool do_trunc = false;

void check (const vec<Float>& y, const char* expr)
{
    static int i = 0;
    cout << "y=" << expr    << ";\n";
    cout << "z=" << ml << y << ";\n";

    if (do_trunc) {
        cout << "error" << ++i << "=eps1*round(norm(y-z)/eps1)\n\n";
    } else {
        cout << "error" << ++i << "=norm(y-z)\n\n";
    }

}
int main (int argc, char* argv[])
{	
    // avoid machine-dependent output digits in non-regression mode:
    if (argc == 3) {
        cout.setf(ios::scientific, ios::floatfield);
        int digits10 = numeric_limits<Float>::digits10;
    
	do_trunc = true;
        digits10 = atoi(argv[2]);
	cout << "eps1=sqrt(10^(-" << digits10 << "));\n";
    
        cout << setprecision(digits10);
    }
    csr<Float> a;
    cin >> a;

    cout << "a=" << ml << a << ";\n";
  
  // simple product: allocate 'x'
    vec<Float> x(a.ncol());
    x = 1;
    cout << "x=" << ml << x << ";\n";

  // simple product: allocate 'y'
    vec<Float> y = a*x;
    check (y, "a*x");

  // more complex expression, without any temporaries
    y = a*x - y;
    check (y, "a*x - y");
  
  // here, need a temporary because y is in left and right hand
  // and right in 'y'involves a matrix-vector product
    y = a*y - x;
    check (y, "a*y - x");

  // here, need also a temporary because transpose product is not yet expansed
    y = a.trans_mult(x) - x;
    check (y, "a'*x - x");

  return 0;
}
