template <class T>
csr<T> stokes_assembly (const csr<T>& a, const csr<T>& b, const vec<T>& c) {
  size_t n = a.nrow();
  size_t m = b.nrow();
  asr<T> A (n+m+1, n+m+1);
  Array<size_t>::const_iterator ia = a.ia().begin();
  Array<size_t>::const_iterator ja = a.ja().begin();
  typename Array<T>::const_iterator va = a.a().begin();
  Array<size_t>::const_iterator ib = b.ia().begin();
  Array<size_t>::const_iterator jb = b.ja().begin();
  typename Array<T>::const_iterator vb = b.a().begin();
  typename Array<T>::const_iterator vc = c.begin();
  for (size_t i = 0; i < n; i++) {
    for (size_t p = ia[i]; p < ia[i+1]; p++) {
      A.entry(i,ja[p]) = va[p];
    }
  }
  for (size_t i = 0; i < m; i++) {
    for (size_t q = ib[i]; q < ib[i+1]; q++) {
      A.entry(n+i,jb[q]) = A.entry(jb[q],n+i) = vb[q];
    }
    A.entry(n+i,n+m) = A.entry(n+m,n+i) = vc[i];
  }
  return csr<T>(A);
}
