from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


MET = _Mock()

cast_bytes = _Mock()

connect_logger = _Mock()

decorator = _Mock()

error = _Mock()

ioloop = _Mock()

launch_scheduler = _Mock()

leastload = _Mock()

local_logger = _Mock()

logged = _Mock()

logging = _Mock()

lru = _Mock()

numpy = _Mock()

plainrandom = _Mock()

randint = _Mock()

random = _Mock()

sys = _Mock()

time = _Mock()

twobin = _Mock()

util = _Mock()

weighted = _Mock()

zmq = _Mock()

zmqstream = _Mock()



class Application(_Mock):
  pass


class CBytes(_Mock):
  pass
  default_value = ''
  info_text = 'a bytes object'

class Config(_Mock):
  pass


class Dependency(_Mock):
  pass
  all = True
  failure = True
  success = True

class Dict(_Mock):
  pass
  info_text = 'any value'

class Enum(_Mock):
  pass
  info_text = 'any value'

class FunctionType(_Mock):
  pass


class Instance(_Mock):
  pass
  info_text = 'any value'

class Integer(_Mock):
  pass
  default_value = 0
  info_text = 'an integer'

class Job(_Mock):
  pass


class List(_Mock):
  pass
  info_text = 'any value'

class SessionFactory(_Mock):
  pass


class Set(_Mock):
  pass
  info_text = 'any value'

class TaskScheduler(_Mock):
  pass


class datetime(_Mock):
  pass


class deque(_Mock):
  pass


