# Contributing to bioSyntax

Thank you for your interest in contributing to bioSyntax!

**bioSyntax** is a syntax highlighting package for computational biology to bring you intuitively close to your data.

If you would like to contribute to **bioSyntax** on GitHub, please follow this set of guidelines to easily get involved.

## Partipation Guidelines

This project adheres to a [code of conduct](https://www.mozilla.org/en-US/about/governance/policies/participation/), and by participating, you are expected to uphold it as well. Please report unacceptable behaviour to [info at bioSyntax.org](mailto:info@bioSyntax.org), or any of the core developers.

## Current Goals

We currently have a handful of things we would like to accomplish during the Sprint. Have a look at our [Sprint master post](https://github.com/bioSyntax/bioSyntax/issues/38) to find out more about them.

For background information to help you start building, please refer to our [manual](https://biosyntax.org/dev).

## How to Submit Changes

Once you've figured out where you'd like to contribute:

1. [Fork](https://help.github.com/articles/fork-a-repo/) the **bioSyntax** repository to make your own version of the project that you can use and modify.
2. Make your changes in the GitHub interface or locally on your own machine, with a text editor/IDE of your choice. If you're making big changes that have a lot of dependencies on other files in the **bioSyntax** repository, consider [using branches](https://www.atlassian.com/git/tutorials/using-branches) for your work. This way, you can keep your repository up-to-date of any other changes made to files that you're using without losing your own work.
3. Once you're done, [submit a pull request](https://www.atlassian.com/git/tutorials/making-a-pull-request). This will let the core developers know you're proposing changes to the project and invites discussion on your changes, in case anything needs to be fixed or improved before committed to the repository.

If you're really new to contributing to open source projects on GitHub, check out this [tutorial](https://egghead.io/courses/how-to-contribute-to-an-open-source-project-on-github).

## How to Report Bugs

We invite you to try out **bioSyntax** and keep an eye out for anything that needs fixing or may cause potential problems in future. Whether it's bugs in the code, errors in content, or even user interface or experience issues, please [report](https://github.com/bioSyntax/bioSyntax/issues) any of these as an issue on the **bioSyntax** repository, so we can all work together to resolve them.

## Communication Channels

Stay in the loop with us through Slack or Discord below:
- [Slack Channel](https://join.slack.com/t/biosyntax/shared_invite/enQtMzU5OTAwNTc0MjI5LTIxNGU4YzQ1ODljZjg0OTE2M2Y5MDY0MjUwOTA4ZjIwMjVjYjgzNTA5ZGM1ZTliNDMwMGUxMmUzOTI3YWMwOTk) (NOTE: Invite link expires on May 13; contact dev team for invites subsequently)
- [Discord Server](https://discord.gg/PAD6y4p) (NOTE: Invite link expires on May 13; contact dev team for invites subsequently)

Alternatively, you may direct any questions you may have to [info at bioSyntax.org](mailto:info@bioSyntax.org), or any of the core developers.

## Developer's Certificate of Origin 1.1

By making a contribution to this project, I certify that:

* (a) The contribution was created in whole or in part by me and I
  have the right to submit it under the open source license
  indicated in the file; or

* (b) The contribution is based upon previous work that, to the best
  of my knowledge, is covered under an appropriate open source
  license and I have the right under that license to submit that
  work with modifications, whether created in whole or in part
  by me, under the same open source license (unless I am
  permitted to submit under a different license), as indicated
  in the file; or

* (c) The contribution was provided directly to me by some other
  person who certified (a), (b) or (c) and I have not modified
  it.

* (d) I understand and agree that this project and the contribution
  are public and that a record of the contribution (including all
  personal information I submit with it, including my sign-off) is
  maintained indefinitely and may be redistributed consistent with
  this project or the open source license(s) involved.
