// Copyright 2005, FreeHEP.
package org.freehep.graphicsio.pdf.test;

import java.awt.Rectangle;
import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.io.*;
import java.util.Calendar;

import org.freehep.graphics2d.font.CharTable;
import org.freehep.graphics2d.font.Lookup;
import org.freehep.graphicsio.font.FontEmbedder;
import org.freehep.graphicsio.pdf.PDFFontEmbedderType1;
import org.freehep.graphicsio.pdf.PDFFontEmbedderType3;
import org.freehep.graphicsio.pdf.PDFWriter;
import org.freehep.graphicsio.pdf.PDFDocInfo;
import org.freehep.graphicsio.pdf.PDFCatalog;
import org.freehep.graphicsio.pdf.PDFViewerPreferences;
import org.freehep.graphicsio.pdf.PDFDictionary;
import org.freehep.graphicsio.pdf.PDFPageTree;
import org.freehep.graphicsio.pdf.PDFPage;
import org.freehep.graphicsio.pdf.PDFStream;
import org.freehep.graphicsio.pdf.PDFRedundanceTracker;

public class TestPDFFontEmbedding {

    public static void main(String[] argv) {

	try {

	    PDFWriter pdf = new PDFWriter(new FileOutputStream("fonttest.pdf"));
	    pdf.comment("file generated by TestFontEmbedding, Freehep lib");

	    // info
	    PDFDocInfo info = pdf.openDocInfo("DocInfo");
	    info.setTitle("Font Embedding Test");
	    info.setAuthor("Simon Fischer");
	    info.setSubject("Test File of the Font Embedding of the FreeHEP library");
	    info.setKeywords("PDFWriter; FreeHEP");
	    info.setCreator(TestPDFFontEmbedding.class.getName());
	    info.setCreationDate(Calendar.getInstance());
	    pdf.close(info);

	    // catalog
	    PDFCatalog catalog = pdf.openCatalog("Catalog", "RootPage");
	    catalog.setPageMode("UseOutlines");
	    catalog.setViewerPreferences("Preferences");
	    catalog.setOpenAction(new Object[] { pdf.ref("FontPage"), pdf.name("Fit")});
	    pdf.close(catalog);

	    // preferences
	    PDFViewerPreferences prefs = pdf.openViewerPreferences("Preferences");
	    prefs.setFitWindow(true);
	    prefs.setCenterWindow(false);
	    pdf.close(prefs);

	    // pages
	    PDFPageTree pages = pdf.openPageTree("RootPage", null);
	    pages.addPage("FontPage");
	    pages.setMediaBox(0, 0, 612, 792);
	    pages.setResources("Resources");
	    pdf.close(pages);

	    // page
	    PDFPage fontPage = pdf.openPage("FontPage", "RootPage");
	    fontPage.setContents("FontPageContent");
	    pdf.close(fontPage);

	    // first page content
	    PDFStream pageStream = pdf.openStream("FontPageContent",
						  new String[] { "Flate", "ASCIIHex" });

	    pageStream.move(100,100);
	    pageStream.line(200,200);
	    pageStream.stroke();

	    pageStream.beginText();
	    pageStream.font(pdf.name("F1"), 12);
	    pageStream.text(100, 200);
	    pageStream.show("ABC abc!");
	    pageStream.endText();

	    CharTable table = Lookup.getInstance().getTable("PDFLatin");
	    String str = "";
	    double y = 500;
	    for (int i=1; i<256; i++) {
		String name = table.toName(i);
		if (name != null)
		    str += table.toUnicode(name);
		else
		    str += "#";
		if ((str.length() % 32 == 31) || (i == 255)) {
		    pageStream.beginText();
		    pageStream.font(pdf.name("F1"), 12);
		    pageStream.text(100, y);
		    pageStream.show(str);
		    pageStream.endText();
		    System.out.println(str);
		    str = "";
		    y -= 20;
		}
	    }

	    pdf.close(pageStream);


	    // resources
	    PDFDictionary resources = pdf.openDictionary("Resources");
	    resources.entry("ProcSet", pdf.ref("OurPageProcSet"));
	    PDFDictionary fontList = resources.openDictionary("Font");
	    fontList.entry("F1", pdf.ref("MyFont"));
	    resources.close(fontList);
	    pdf.close(resources);

	    pdf.object("OurPageProcSet", new Object[] { pdf.name("PDF") });

	    PDFRedundanceTracker tracker = new PDFRedundanceTracker(pdf);

	    // font embedding
	    switch (3) {
	    case 1:
		PDFDictionary fontDict = pdf.openDictionary("MyFont");
		fontDict.entry("Type", pdf.name("Font"));
		fontDict.entry("Subtype", pdf.name("Type1"));
		fontDict.entry("Name", pdf.name("F1"));
		fontDict.entry("BaseFont", pdf.name("Helvetica"));
		pdf.close(fontDict);
		break;

	    case 2:
		Font font = new Font("Monotype Corsiva", Font.PLAIN, 1000);
		FontRenderContext context = new FontRenderContext(null, true, true);
		FontEmbedder fe = new PDFFontEmbedderType3(context, pdf, "MyFont", tracker);
		fe.includeFont(font, Lookup.getInstance().getTable("PDFLatin"), "F1");
		break;

	    case 3:
		font = new Font("Impact", Font.PLAIN, 1000);
		context = new FontRenderContext(null, true, true);
		fe = PDFFontEmbedderType1.create(context, pdf, "MyFont", tracker);
		fe.includeFont(font, Lookup.getInstance().getTable("PDFLatin"), "F1");
		break;
	    }

	    tracker.writeAll();

	    pdf.close();
	    System.exit(0);
	} catch (Exception e) {
	    e.printStackTrace();
	}
    }
}
